/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.FirestormFallEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RandomUtil;

public class FirestormStaff
extends BaseStaff<BlockPos> {
    public FirestormStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NIGHTMARE_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.COMPASS_RUNE.get(), 1);
        runes.put((Item)AoAItems.FIRE_RUNE.get(), 2);
        runes.put((Item)AoAItems.LUNAR_RUNE.get(), 2);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof Player) {
            trace = PlayerUtil.getBlockAimingAt((Player)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, BlockPos args) {
        for (int i = 0; i < 8; ++i) {
            world.m_7967_((Entity)new FirestormFallEntity(caster, this, (float)(args.m_123341_() - 4) + RandomUtil.randomValueUpTo(8.0f), args.m_123342_() + 30, (float)(args.m_123343_() - 4) + RandomUtil.randomValueUpTo(8.0f), 3.0f));
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            if (target instanceof LivingEntity) {
                target.m_20254_(7);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 32.0f;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

