/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class FungalStaff
extends BaseStaff<HashMap<BlockPos, Boolean>> {
    public FungalStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_FUNGAL_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 5);
        runes.put((Item)AoAItems.LIFE_RUNE.get(), 2);
    }

    @Override
    @Nullable
    public HashMap<BlockPos, Boolean> checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        HashMap<BlockPos, Boolean> workablePositions = new HashMap<BlockPos, Boolean>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    MushroomBlock mushroom;
                    BlockPos pos = new BlockPos(caster.m_20185_() + (double)x, caster.m_20186_() + (double)y, caster.m_20189_() + (double)z);
                    BlockState state = caster.f_19853_.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block == Blocks.f_50440_) {
                        if (!WorldUtil.canModifyBlock((LevelAccessor)caster.f_19853_, pos, (Entity)caster, staff)) continue;
                        workablePositions.put(pos, true);
                        continue;
                    }
                    if (!(block instanceof MushroomBlock) || !(mushroom = (MushroomBlock)block).m_7370_((BlockGetter)caster.f_19853_, pos, state, caster.f_19853_.m_5776_()) || !WorldUtil.canModifyBlock((LevelAccessor)caster.f_19853_, pos, (Entity)caster, staff)) continue;
                    workablePositions.put(pos, false);
                }
            }
        }
        return workablePositions.isEmpty() ? null : workablePositions;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, HashMap<BlockPos, Boolean> args) {
        if (world instanceof ServerLevel) {
            for (Map.Entry<BlockPos, Boolean> entry : args.entrySet()) {
                BlockPos pos = entry.getKey();
                if (entry.getValue().booleanValue()) {
                    world.m_46597_(pos, Blocks.f_50195_.m_49966_());
                } else {
                    BlockState state = world.m_8055_(pos);
                    MushroomBlock mushroom = (MushroomBlock)state.m_60734_();
                    if (mushroom.m_5491_(world, RandomUtil.RANDOM.source(), pos, state)) {
                        mushroom.m_7719_((ServerLevel)world, RandomUtil.RANDOM.source(), pos, state);
                    }
                }
                world.m_46796_(2005, pos, 0);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

