/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.LyonicShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class MechaStaff
extends BaseStaff<Object> {
    private static final AttributeModifier DEBUFF = new AttributeModifier(UUID.fromString("3a1413c7-055b-405c-8d89-d3270c94f133"), "AoAMechaStaffDebuff", -0.5, AttributeModifier.Operation.MULTIPLY_BASE);

    public MechaStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.WIND_RUNE.get(), 2);
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 1);
        runes.put((Item)AoAItems.POWER_RUNE.get(), 1);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Object args) {
        world.m_7967_((Entity)new LyonicShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            AttributeInstance armour = entity.m_21051_(Attributes.f_22284_);
            if (armour != null && armour.m_22135_() > 0.0 && !armour.m_22109_(DEBUFF)) {
                EntityUtil.applyAttributeModifierSafely(entity, Attributes.f_22284_, DEBUFF, false);
                if (!entity.f_19853_.f_46443_) {
                    AABB bounds = entity.m_142469_();
                    for (int i = 0; i < 8; ++i) {
                        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123767_, bounds.f_82288_ + (double)RandomUtil.randomValueUpTo(entity.m_20205_()), bounds.f_82292_ + 0.1, bounds.f_82290_ + (double)RandomUtil.randomValueUpTo(entity.m_20205_()), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

