/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BonemealableBlock;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class NatureStaff
extends BaseStaff<ArrayList<BlockPos>> {
    public NatureStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NATURE_STAFF_CAST.get();
    }

    @Override
    public ArrayList<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        ArrayList<BlockPos> blocks = WorldUtil.getBlocksWithinAABB(caster.f_19853_, caster.m_142469_().m_82400_(10.0), (state, pos) -> {
            if (!(state.m_60734_() instanceof BonemealableBlock)) {
                return false;
            }
            if (!((BonemealableBlock)state.m_60734_()).m_7370_((BlockGetter)caster.f_19853_, pos.m_7949_(), state, false)) {
                return false;
            }
            return WorldUtil.canModifyBlock((LevelAccessor)caster.f_19853_, (BlockPos)pos, (Entity)caster, staff);
        });
        return blocks.isEmpty() ? null : blocks;
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.LIFE_RUNE.get(), 4);
        runes.put((Item)AoAItems.ENERGY_RUNE.get(), 2);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, ArrayList<BlockPos> args) {
        for (BlockPos pos : args) {
            BoneMealItem.m_40627_((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)caster.f_19853_, (BlockPos)pos);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

