/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.UltimatumShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.scheduling.sync.UltimatumStaffTask;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class UltimatumStaff
extends BaseStaff<Object> {
    public UltimatumStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_ULTIMATUM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.LIFE_RUNE.get(), 5);
        runes.put((Item)AoAItems.POWER_RUNE.get(), 3);
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 8);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, Object args) {
        world.m_7967_((Entity)new UltimatumShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity && !EntityUtil.isImmuneToSpecialAttacks(target, shooter)) {
            Vec3 lookVec = shooter.m_20154_();
            double posX = shooter.m_20185_() + lookVec.f_82479_ * 4.0;
            double posZ = shooter.m_20189_() + lookVec.f_82481_ * 4.0;
            target.m_19890_(posX, shooter.m_20186_(), posZ, (shooter.f_20885_ + 180.0f) % 360.0f, 0.0f);
            target.m_5616_((shooter.f_20885_ + 180.0f) % 360.0f);
            target.m_6021_(posX, shooter.m_20186_(), posZ);
            AoAScheduler.scheduleSyncronisedTask(new UltimatumStaffTask(shooter, (LivingEntity)target), 2);
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new TextComponent[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.specImmune", LocaleUtil.ItemDescriptionType.HARMFUL, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

