/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;

public class WebStaff
extends BaseStaff<ArrayList<MobEffect>> {
    public WebStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_WEB_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 4);
        runes.put((Item)AoAItems.ENERGY_RUNE.get(), 4);
    }

    @Override
    public ArrayList<MobEffect> checkPreconditions(LivingEntity caster, ItemStack staff) {
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>(caster.m_21220_().size());
        for (MobEffectInstance effect : caster.m_21220_()) {
            if (effect.m_19544_().m_19486_()) continue;
            effects.add(effect.m_19544_());
        }
        return effects.size() > 0 ? effects : null;
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, ArrayList<MobEffect> args) {
        args.forEach(arg_0 -> ((LivingEntity)caster).m_21195_(arg_0));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

