/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class PrimalSword
extends BaseSword {
    public PrimalSword() {
        super(AoATiers.PRIMAL);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        if (world.m_46467_() % 10L == 0L && entity instanceof LivingEntity) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            try {
                if (isSelected) {
                    float currentCalcBuff;
                    float currentDamageMod = cap.getValue();
                    if (currentDamageMod != (currentCalcBuff = this.getCurrentDamageBuff(entity))) {
                        ((LivingEntity)entity).m_21204_().m_22161_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                        cap.setValue(currentCalcBuff);
                        ((LivingEntity)entity).m_21204_().m_22178_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                    }
                } else if (cap.getValue() != 0.0f && ((LivingEntity)entity).m_21205_().m_41619_()) {
                    ((LivingEntity)entity).m_21204_().m_22161_(this.getAttributeModifiers(EquipmentSlot.MAINHAND, stack));
                    cap.setValue(0.0f);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    private float getCurrentDamageBuff(Entity holder) {
        if (holder instanceof LivingEntity) {
            float armour = (float)((LivingEntity)holder).m_21051_(Attributes.f_22284_).m_22135_();
            if (armour > 15.0f) {
                return 15.0f / armour;
            }
            return 1.5f - armour / 30.0f;
        }
        return 1.0f;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> modifierMap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            ItemUtil.setAttribute(modifierMap, Attributes.f_22281_, f_41374_, this.m_43299_() * (cap.getValue() == 0.0f ? 1.0f : cap.getValue()));
        }
        return modifierMap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new TextComponent[0]));
    }
}

