/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class SweetSword
extends BaseSword {
    private static final ArrayList<ItemStack> candyList = new ArrayList();
    private static boolean populated = false;

    public SweetSword() {
        super(AoATiers.SWEET);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        if (RandomUtil.percentChance(0.2f * attackCooldown)) {
            if (!populated) {
                SweetSword.populateCandyList();
            }
            target.m_5552_(RandomUtil.getRandomSelection(candyList), target.m_20206_() / 2.0f);
        }
    }

    private static void populateCandyList() {
        candyList.add(new ItemStack((ItemLike)Items.f_42501_, 3));
        ((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(Registry.f_122904_).get()).m_203431_(AoATags.Items.CANDY).ifPresent(tag -> tag.forEach(item -> candyList.add(new ItemStack(item))));
        populated = true;
    }

    public static void addCandyDrop(ItemStack stack) {
        if (!populated) {
            SweetSword.populateCandyList();
        }
        candyList.add(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new TextComponent[0]));
    }
}

