/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.function;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoALootOperations;
import org.apache.logging.log4j.Level;

public class EnchantSpecific
extends LootItemConditionalFunction {
    private final HashMap<Enchantment, Integer> enchants;

    protected EnchantSpecific(LootItemCondition[] lootConditions, List<EnchantmentInstance> enchantments) {
        super(lootConditions);
        this.enchants = new HashMap(enchantments.size());
        for (EnchantmentInstance ench : enchantments) {
            this.enchants.put(ench.f_44947_, ench.f_44948_);
        }
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)AoALootOperations.LootFunctions.ENCHANT_SPECIFIC.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        EnchantmentHelper.m_44865_(this.enchants, (ItemStack)stack);
        return stack;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return ImmutableMap.copyOf(this.enchants);
    }

    public static LootItemConditionalFunction.Builder<?> builder(EnchantmentInstance ... enchantments) {
        return EnchantSpecific.m_80683_(conditions -> new EnchantSpecific((LootItemCondition[])conditions, Arrays.asList(enchantments)));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<EnchantSpecific> {
        public void serialize(JsonObject object, EnchantSpecific function, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)function, context);
            JsonArray enchantments = new JsonArray();
            for (Map.Entry<Enchantment, Integer> enchantEntry : function.enchants.entrySet()) {
                JsonObject enchantObject = new JsonObject();
                enchantObject.addProperty("id", enchantEntry.getKey().getRegistryName().toString());
                enchantObject.addProperty("level", (Number)enchantEntry.getValue());
                enchantments.add((JsonElement)enchantObject);
            }
            object.add("enchantments", (JsonElement)enchantments);
        }

        public EnchantSpecific deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            JsonElement enchantmentsObject;
            ArrayList<EnchantmentInstance> enchants = new ArrayList<EnchantmentInstance>();
            if (object.has("enchantments") && (enchantmentsObject = object.get("enchantments")).isJsonArray()) {
                for (JsonElement element : enchantmentsObject.getAsJsonArray()) {
                    JsonObject enchantObject;
                    if (!element.isJsonObject() || !(enchantObject = element.getAsJsonObject()).has("id") || !enchantObject.has("level")) continue;
                    Enchantment enchant = null;
                    int level = 1;
                    try {
                        JsonElement levelElement;
                        JsonElement idElement = enchantObject.get("id");
                        if (idElement.isJsonPrimitive()) {
                            enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(idElement.getAsJsonPrimitive().getAsString()));
                        }
                        if ((levelElement = enchantObject.get("level")).isJsonPrimitive()) {
                            level = levelElement.getAsJsonPrimitive().getAsInt();
                        }
                        enchants.add(new EnchantmentInstance(enchant, level));
                    }
                    catch (Exception ex) {
                        Logging.logMessage(Level.ERROR, "Invalid data type for enchant in EnchantSpecific deserialization, skipping entry");
                    }
                }
            }
            return new EnchantSpecific(conditions, enchants);
        }
    }
}

