/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public class RollExtraTablesLootModifier
extends LootModifier {
    private final ResourceLocation[] additionalTables;

    public RollExtraTablesLootModifier(LootItemCondition[] conditions, ResourceLocation[] additionalTables) {
        super(conditions);
        this.additionalTables = additionalTables;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (ResourceLocation tableLocation : this.additionalTables) {
            LootTable table = context.m_78940_(tableLocation);
            boolean compatible = true;
            for (LootContextParam param : table.m_79122_().m_81394_()) {
                if (context.m_78936_(param)) continue;
                compatible = false;
                Logging.logMessage(Level.WARN, "Incompatible loot table found for Roll Extra Tables Loot Modifier: " + tableLocation.toString() + ", missing: " + param.m_81284_().toString());
                break;
            }
            if (!compatible || table == LootTable.f_79105_) continue;
            table.m_79148_(context, generatedLoot::add);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RollExtraTablesLootModifier> {
        public RollExtraTablesLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            JsonArray tables = GsonHelper.m_13933_((JsonObject)object, (String)"tables");
            ResourceLocation[] tableList = new ResourceLocation[tables.size()];
            for (int i = 0; i < tables.size(); ++i) {
                tableList[i] = new ResourceLocation(tables.get(i).getAsString());
            }
            return new RollExtraTablesLootModifier(lootConditions, tableList);
        }

        public JsonObject write(RollExtraTablesLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            JsonArray tables = new JsonArray();
            for (ResourceLocation table : instance.additionalTables) {
                tables.add(table.toString());
            }
            json.add("tables", (JsonElement)tables);
            json.addProperty("type", this.getRegistryName().toString());
            return json;
        }
    }
}

