/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.advent.Logging;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.Level;

public class JigsawAssembler {
    protected final Registry<StructureTemplatePool> poolRegistry;
    protected final int maxDepth;
    protected final JigsawPlacement.PieceFactory pieceFactory;
    protected final ChunkGenerator chunkGenerator;
    protected final StructureManager structureManager;
    protected final List<? super PoolElementStructurePiece> pieces;
    protected final Random random;
    protected final Deque<Entry> placementQueue = Queues.newArrayDeque();

    public JigsawAssembler(Registry<StructureTemplatePool> poolRegistry, int maxDepth, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieceList, Random rand) {
        this.poolRegistry = poolRegistry;
        this.maxDepth = maxDepth;
        this.pieceFactory = pieceFactory;
        this.chunkGenerator = chunkGenerator;
        this.structureManager = structureManager;
        this.pieces = pieceList;
        this.random = rand;
    }

    public void tryPlacingChildren(PoolElementStructurePiece elementPiece, MutableObject<VoxelShape> freeBounds, int pieceDepth, boolean doExpansionHack, LevelHeightAccessor level) {
        StructurePoolElement poolElement = elementPiece.m_209918_();
        StructureTemplatePool.Projection projection = poolElement.m_210539_();
        boolean isRigid = projection == StructureTemplatePool.Projection.RIGID;
        MutableObject shapeHolder = new MutableObject();
        BoundingBox elementPieceBounds = elementPiece.m_73547_();
        int yMin = elementPieceBounds.m_162396_();
        for (StructureTemplate.StructureBlockInfo jigsawBlock : poolElement.m_207245_(this.structureManager, elementPiece.m_72646_(), elementPiece.m_6830_(), this.random)) {
            this.handleJunctions(jigsawBlock, yMin, elementPieceBounds, (MutableObject<VoxelShape>)shapeHolder, freeBounds, pieceDepth, doExpansionHack, isRigid, level, projection, elementPiece);
        }
    }

    @Nullable
    protected Pair<StructureTemplatePool, StructureTemplatePool> getPools(StructureTemplate.StructureBlockInfo jigsawInfo, int yMin) {
        StructureTemplatePool pool = this.getPool(new ResourceLocation(jigsawInfo.f_74677_.m_128461_("pool")));
        if (pool == null) {
            return null;
        }
        StructureTemplatePool fallbackPool = this.getPool(pool.m_210573_());
        return fallbackPool == null ? null : Pair.of((Object)pool, (Object)fallbackPool);
    }

    @Nullable
    protected StructureTemplatePool getPool(ResourceLocation poolPath) {
        Optional pool = this.poolRegistry.m_6612_(poolPath);
        if (pool.isEmpty() || ((StructureTemplatePool)pool.get()).m_210590_() == 0 && !Objects.equals(poolPath, Pools.f_127186_.m_135782_())) {
            Logging.logMessage(Level.WARN, "Invalid pool for structure piece: " + poolPath);
            return null;
        }
        return (StructureTemplatePool)pool.get();
    }

    protected void handleJunctions(StructureTemplate.StructureBlockInfo jigsawBlock, int yMin, BoundingBox elementPieceBounds, MutableObject<VoxelShape> shapeHolder, MutableObject<VoxelShape> freeBounds, int pieceDepth, boolean doExpansionHack, boolean isRigid, LevelHeightAccessor level, StructureTemplatePool.Projection projection, PoolElementStructurePiece elementPiece) {
        StructurePoolElement nextPoolElement;
        MutableObject<VoxelShape> pieceFreeBounds;
        BlockPos jigsawPos = jigsawBlock.f_74675_;
        BlockPos jigsawFacingPos = jigsawPos.m_142300_(JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_));
        int jigsawYDelta = jigsawPos.m_123342_() - yMin;
        int baseHeight = -1;
        Pair<StructureTemplatePool, StructureTemplatePool> pools = this.getPools(jigsawBlock, yMin);
        if (pools == null) {
            return;
        }
        ArrayList poolElements = Lists.newArrayList();
        if (elementPieceBounds.m_71051_((Vec3i)jigsawFacingPos)) {
            pieceFreeBounds = shapeHolder;
            if (shapeHolder.getValue() == null) {
                shapeHolder.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)elementPieceBounds)));
            }
        } else {
            pieceFreeBounds = freeBounds;
        }
        if (pieceDepth != this.maxDepth) {
            poolElements.addAll(((StructureTemplatePool)pools.getFirst()).m_210588_(this.random));
        }
        poolElements.addAll(((StructureTemplatePool)pools.getSecond()).m_210588_(this.random));
        Iterator iterator = poolElements.iterator();
        while (iterator.hasNext() && (nextPoolElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
            for (Rotation rotation : Rotation.m_55958_((Random)this.random)) {
                List nextPoolElementJigsawBlocks = nextPoolElement.m_207245_(this.structureManager, BlockPos.f_121853_, rotation, this.random);
                BoundingBox subElementBounds = nextPoolElement.m_207470_(this.structureManager, BlockPos.f_121853_, rotation);
                int subPoolElementSize = doExpansionHack && subElementBounds.m_71057_() <= 16 ? nextPoolElementJigsawBlocks.stream().mapToInt(jigsaw -> {
                    if (!subElementBounds.m_71051_((Vec3i)jigsaw.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)jigsaw.f_74676_)))) {
                        return 0;
                    }
                    ResourceLocation poolId = new ResourceLocation(jigsaw.f_74677_.m_128461_("pool"));
                    Optional mainSubPool = this.poolRegistry.m_6612_(poolId);
                    Optional<Integer> fallbackSubPool = mainSubPool.flatMap(pool -> this.poolRegistry.m_6612_(pool.m_210573_()));
                    int mainPoolSize = mainSubPool.map(pool -> pool.m_210580_(this.structureManager)).orElse(0);
                    int fallbackPoolSize = fallbackSubPool.map(pool -> pool.m_210580_(this.structureManager)).orElse(0);
                    return Math.max(mainPoolSize, fallbackPoolSize);
                }).max().orElse(0) : 0;
                for (StructureTemplate.StructureBlockInfo nextPoolElementJigsawBlock : nextPoolElementJigsawBlocks) {
                    int yAdjust;
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)jigsawBlock, (StructureTemplate.StructureBlockInfo)nextPoolElementJigsawBlock)) continue;
                    BlockPos nextPoolElementJigsawBlockPos = nextPoolElementJigsawBlock.f_74675_;
                    BlockPos alignedJigsawPos = jigsawFacingPos.m_141950_((Vec3i)nextPoolElementJigsawBlockPos);
                    BoundingBox nextPoolElementBounds = nextPoolElement.m_207470_(this.structureManager, alignedJigsawPos, rotation);
                    int nextPoolElementMinY = nextPoolElementBounds.m_162396_();
                    StructureTemplatePool.Projection nextPoolElementProjection = nextPoolElement.m_210539_();
                    boolean nextPoolElementRigid = nextPoolElementProjection == StructureTemplatePool.Projection.RIGID;
                    int subJigsawPosY = nextPoolElementJigsawBlockPos.m_123342_();
                    int subPieceJigsawDelta = jigsawYDelta - subJigsawPosY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_).m_122430_();
                    if (isRigid && nextPoolElementRigid) {
                        yAdjust = yMin + subPieceJigsawDelta;
                    } else {
                        if (baseHeight == -1) {
                            baseHeight = this.chunkGenerator.m_156174_(jigsawPos.m_123341_(), jigsawPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level);
                        }
                        yAdjust = baseHeight - subJigsawPosY;
                    }
                    int finalYAdjust = yAdjust - nextPoolElementMinY;
                    nextPoolElementBounds = nextPoolElementBounds.m_71045_(0, finalYAdjust, 0);
                    alignedJigsawPos = alignedJigsawPos.m_142082_(0, finalYAdjust, 0);
                    if (subPoolElementSize > 0) {
                        nextPoolElementBounds.m_162371_(new BlockPos(nextPoolElementBounds.m_162395_(), nextPoolElementBounds.m_162396_() + Math.max(subPoolElementSize + 1, nextPoolElementBounds.m_162400_() - nextPoolElementBounds.m_162396_()), nextPoolElementBounds.m_162398_()));
                    }
                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)pieceFreeBounds.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)nextPoolElementBounds).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                    pieceFreeBounds.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)pieceFreeBounds.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)nextPoolElementBounds)), (BooleanOp)BooleanOp.f_82685_));
                    int groundLevelDelta = nextPoolElementRigid ? elementPiece.m_72647_() - subPieceJigsawDelta : nextPoolElement.m_210540_();
                    PoolElementStructurePiece subPoolElementPiece = this.pieceFactory.m_210300_(this.structureManager, nextPoolElement, alignedJigsawPos, groundLevelDelta, rotation, nextPoolElementBounds);
                    if (isRigid) {
                        yAdjust = yMin + jigsawYDelta;
                    } else if (nextPoolElementRigid) {
                        yAdjust += subJigsawPosY;
                    } else {
                        if (baseHeight == -1) {
                            baseHeight = this.chunkGenerator.m_156174_(jigsawPos.m_123341_(), jigsawPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, level);
                        }
                        yAdjust = baseHeight + subPieceJigsawDelta / 2;
                    }
                    elementPiece.m_209916_(new JigsawJunction(jigsawFacingPos.m_123341_(), yAdjust - jigsawYDelta + elementPiece.m_72647_(), jigsawFacingPos.m_123343_(), subPieceJigsawDelta, nextPoolElementProjection));
                    subPoolElementPiece.m_209916_(new JigsawJunction(jigsawPos.m_123341_(), yAdjust - subJigsawPosY + groundLevelDelta, jigsawPos.m_123343_(), -subPieceJigsawDelta, projection));
                    this.pieces.add((PoolElementStructurePiece)subPoolElementPiece);
                    if (pieceDepth + 1 <= this.maxDepth) {
                        this.placementQueue.addLast(new Entry(subPoolElementPiece, pieceFreeBounds, pieceDepth + 1));
                    }
                    return;
                }
            }
        }
    }

    public static <C extends FeatureConfiguration> Optional<PieceGenerator<C>> createPieceGenerator(PieceGeneratorSupplier.Context<C> context, StructureTemplatePool templatePool, JigsawPlacement.PieceFactory pieceFactory, BlockPos rootPos, boolean doExpansionHack, boolean genOnSurface, int maxPieces) {
        StructureFeature.m_67096_();
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        RegistryAccess registries = context.f_197360_();
        ChunkGenerator chunkGenerator = context.f_197352_();
        StructureManager structureManager = context.f_197359_();
        LevelHeightAccessor level = context.f_197357_();
        Predicate predicate = context.f_197358_();
        Registry poolRegistry = registries.m_175515_(Registry.f_122884_);
        rand.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        Rotation rotation = Rotation.m_55956_((Random)rand);
        StructurePoolElement startElement = templatePool.m_210585_((Random)rand);
        if (startElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = pieceFactory.m_210300_(structureManager, startElement, rootPos, startElement.m_210540_(), rotation, startElement.m_207470_(structureManager, rootPos, rotation));
        BoundingBox startBounds = startPiece.m_73547_();
        int centerX = (startBounds.m_162399_() + startBounds.m_162395_()) / 2;
        int centerZ = (startBounds.m_162401_() + startBounds.m_162398_()) / 2;
        int y = genOnSurface ? rootPos.m_123342_() + chunkGenerator.m_156174_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, level) : rootPos.m_123342_();
        if (!predicate.test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)centerX), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)centerZ)))) {
            return Optional.empty();
        }
        int yAdjust = startBounds.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, y - yAdjust, 0);
        return Optional.of((pieceBuilder, context2) -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(startPiece);
            if (maxPieces > 0) {
                AABB safeBounds = new AABB((double)(centerX - 80), (double)level.m_141937_(), (double)(centerZ - 80), (double)(centerX + 80 + 1), (double)level.m_151558_(), (double)(centerZ + 80 + 1));
                JigsawAssembler assembler = new JigsawAssembler((Registry<StructureTemplatePool>)poolRegistry, maxPieces, pieceFactory, chunkGenerator, structureManager, pieces, (Random)rand);
                assembler.placementQueue.addLast(new Entry(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)safeBounds), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startBounds)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!assembler.placementQueue.isEmpty()) {
                    Entry entry = assembler.placementQueue.removeFirst();
                    assembler.tryPlacingChildren(entry.piece, entry.free, entry.depth, doExpansionHack, level);
                }
                pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).m_142679_(arg_0));
            }
        });
    }

    public static void addPieces(RegistryAccess registries, PoolElementStructurePiece startPiece, int maxPieces, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieceList, Random rand, LevelHeightAccessor level) {
        Registry registry = registries.m_175515_(Registry.f_122884_);
        JigsawAssembler assembler = new JigsawAssembler((Registry<StructureTemplatePool>)registry, maxPieces, pieceFactory, chunkGenerator, structureManager, pieceList, rand);
        assembler.placementQueue.addLast(new Entry(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0));
        while (!assembler.placementQueue.isEmpty()) {
            Entry nextPiece = assembler.placementQueue.removeFirst();
            assembler.tryPlacingChildren(nextPiece.piece, nextPiece.free, nextPiece.depth, false, level);
        }
    }

    protected static final class Entry {
        public final PoolElementStructurePiece piece;
        public final MutableObject<VoxelShape> free;
        public final int depth;

        public Entry(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int pieceDepth) {
            this.piece = piece;
            this.free = free;
            this.depth = pieceDepth;
        }
    }
}

