/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.tslat.aoa3.library.object.IntValueProvider;

public class MiscStateAndVariablesConfig
implements FeatureConfiguration {
    public static final Codec<MiscStateAndVariablesConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntValueProvider.CODEC.optionalFieldOf("count", (Object)new IntValueProvider(1)).forGetter(config -> config.count), (App)IntValueProvider.CODEC.optionalFieldOf("x", (Object)new IntValueProvider(0)).forGetter(config -> config.x), (App)IntValueProvider.CODEC.optionalFieldOf("y", (Object)new IntValueProvider(0)).forGetter(config -> config.y), (App)IntValueProvider.CODEC.optionalFieldOf("z", (Object)new IntValueProvider(0)).forGetter(config -> config.z), (App)Codec.BOOL.optionalFieldOf("inverted", (Object)false).forGetter(config -> config.inverted), (App)BlockStateProvider.f_68747_.optionalFieldOf("states", (Object)new SimpleStateProvider(Blocks.f_50016_.m_49966_())).forGetter(config -> config.stateProvider)).apply((Applicative)builder, MiscStateAndVariablesConfig::new));
    public final IntValueProvider count;
    public final IntValueProvider x;
    public final IntValueProvider y;
    public final IntValueProvider z;
    public final boolean inverted;
    public final BlockStateProvider stateProvider;

    public MiscStateAndVariablesConfig(IntValueProvider count, IntValueProvider x, IntValueProvider y, IntValueProvider z, boolean inverted, BlockStateProvider stateProvider) {
        this.count = count;
        this.x = x;
        this.y = y;
        this.z = z;
        this.inverted = inverted;
        this.stateProvider = stateProvider;
    }

    public static class Builder {
        private IntValueProvider count = new IntValueProvider(1);
        private IntValueProvider x = new IntValueProvider(0);
        private IntValueProvider y = new IntValueProvider(0);
        private IntValueProvider z = new IntValueProvider(0);
        private boolean inverted = false;
        private final ArrayList<Pair<BlockState, Integer>> blocks = new ArrayList();

        public Builder amount(int amount) {
            return this.amount(amount, amount);
        }

        public Builder amount(int min, int max) {
            this.count = new IntValueProvider(min, max);
            return this;
        }

        public Builder x(int amount) {
            return this.x(amount, amount);
        }

        public Builder x(int min, int max) {
            this.x = new IntValueProvider(min, max);
            return this;
        }

        public Builder y(int amount) {
            return this.y(amount, amount);
        }

        public Builder y(int min, int max) {
            this.y = new IntValueProvider(min, max);
            return this;
        }

        public Builder z(int amount) {
            return this.z(amount, amount);
        }

        public Builder z(int min, int max) {
            this.z = new IntValueProvider(min, max);
            return this;
        }

        public Builder generateDownwards() {
            this.inverted = true;
            return this;
        }

        public Builder withBlock(BlockState state) {
            return this.withBlock(state, 1);
        }

        public Builder withBlock(BlockState state, int weight) {
            this.blocks.add((Pair<BlockState, Integer>)Pair.of((Object)state, (Object)weight));
            return this;
        }

        public MiscStateAndVariablesConfig build() {
            SimpleStateProvider stateProvider;
            if (this.blocks.isEmpty()) {
                throw new IllegalArgumentException("No blocks provider for misc state and variables config!");
            }
            if (this.blocks.size() == 1) {
                stateProvider = new SimpleStateProvider((BlockState)this.blocks.get(0).getFirst());
            } else {
                SimpleWeightedRandomList.Builder blockListBuilder = new SimpleWeightedRandomList.Builder();
                for (Pair<BlockState, Integer> pair : this.blocks) {
                    blockListBuilder.m_146271_((Object)((BlockState)pair.getFirst()), ((Integer)pair.getSecond()).intValue());
                }
                stateProvider = new WeightedStateProvider(blockListBuilder);
            }
            return new MiscStateAndVariablesConfig(this.count, this.x, this.y, this.z, this.inverted, (BlockStateProvider)stateProvider);
        }
    }
}

