/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class ChurryTreeFeature
extends AoATreeFeature {
    public ChurryTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 25 + rand.nextInt(15);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 3, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.CHURRY_LOG.get()).m_49966_();
        BlockState lelyetianLeaves = ((Block)AoABlocks.LELYETIAN_LEAVES.get()).m_49966_();
        int leafGap = 0;
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (i <= 6 || ++leafGap <= 6 || leafGap <= 11 && rand.nextInt(5) != 0) continue;
            leafGap = 0;
            this.buildLeafBlob(reader, movablePos.m_7949_(), rand);
        }
        this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 3; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), lelyetianLeaves);
                }
            }
        }
        return true;
    }

    private void buildLeafBlob(WorldGenLevel reader, BlockPos pos, Random rand) {
        int x;
        BlockState leaves = ((Block)AoABlocks.CHURRY_LEAVES.get()).m_49966_();
        this.placeBlock(reader, pos.m_142127_(), leaves);
        this.placeBlock(reader, pos.m_142128_(), leaves);
        this.placeBlock(reader, pos.m_142126_(), leaves);
        this.placeBlock(reader, pos.m_142125_(), leaves);
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                this.placeBlock(reader, pos.m_142082_(x, -1, z), leaves);
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int y = -2; y >= -3; --y) {
                for (int z = -2; z <= 2; ++z) {
                    if ((x == 2 || x == -2) && (z == 2 || z == -2)) continue;
                    this.placeBlock(reader, pos.m_142082_(x, y, z), leaves);
                }
            }
        }
        pos = pos.m_6625_(3);
        this.placeBlock(reader, pos.m_142390_(3), leaves);
        this.placeBlock(reader, pos.m_142383_(3), leaves);
        this.placeBlock(reader, pos.m_142385_(3), leaves);
        this.placeBlock(reader, pos.m_142386_(3), leaves);
        if (rand.nextBoolean()) {
            this.placeBlock(reader, pos.m_142390_(4), leaves);
            this.placeBlock(reader, pos.m_142383_(4), leaves);
            this.placeBlock(reader, pos.m_142385_(4), leaves);
            this.placeBlock(reader, pos.m_142386_(4), leaves);
        }
        this.placeBlock(reader, pos.m_142127_(), leaves);
        this.placeBlock(reader, pos.m_142128_(), leaves);
        this.placeBlock(reader, pos.m_142126_(), leaves);
        this.placeBlock(reader, pos.m_142125_(), leaves);
    }
}

