/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class DawnwoodTreeFeature
extends AoATreeFeature {
    public DawnwoodTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 15 + rand.nextInt(10);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.DAWN_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.DAWN_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
            if (rand.nextInt(4) == 0) {
                this.placeBlock(reader, movablePos.m_142127_(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(reader, movablePos.m_142128_(), leaves);
            }
            if (rand.nextInt(4) == 0) {
                this.placeBlock(reader, movablePos.m_142126_(), leaves);
            }
            if (rand.nextInt(4) != 0) continue;
            this.placeBlock(reader, movablePos.m_142125_(), leaves);
        }
        if (rand.nextInt(3) == 0) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, movablePos.m_142082_(x, -1, z), leaves);
                    this.placeBlock(reader, movablePos.m_142082_(x, 1, z), leaves);
                }
            }
            int leafWidth = 2 + rand.nextInt(2);
            for (int x = -leafWidth; x <= leafWidth; ++x) {
                for (int z = -leafWidth; z <= leafWidth; ++z) {
                    this.placeBlock(reader, movablePos.m_142082_(x, 0, z), leaves);
                }
            }
            this.placeBlock(reader, movablePos.m_142082_(0, 2, 0), leaves);
            this.placeBlock(reader, movablePos.m_142082_(1, -2, 0), leaves);
            this.placeBlock(reader, movablePos.m_142082_(-1, -2, 0), leaves);
            this.placeBlock(reader, movablePos.m_142082_(0, -2, 1), leaves);
            this.placeBlock(reader, movablePos.m_142082_(0, -2, -1), leaves);
        } else if (rand.nextBoolean()) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), leaves);
        }
        return true;
    }
}

