/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class EyeHangerTreeFeature
extends AoATreeFeature {
    public EyeHangerTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int i;
        int weaveHeight;
        int trunkHeight = 5 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (weaveHeight = 8 + rand.nextInt(8)), 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.SHADOW_LOG.get()).m_49966_();
        BlockState barkLog = ((Block)AoABlocks.SHADOW_WOOD.get()).m_49966_();
        int branchWidth = 1 + rand.nextInt(3);
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        for (i = 1; i <= branchWidth; ++i) {
            this.placeBlock(reader, movablePos.m_142082_(i, 0, 0), barkLog);
            this.placeBlock(reader, movablePos.m_142082_(-i, 0, 0), barkLog);
            this.placeBlock(reader, movablePos.m_142082_(0, 0, i), barkLog);
            this.placeBlock(reader, movablePos.m_142082_(0, 0, -i), barkLog);
            if (i != branchWidth || !rand.nextBoolean()) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 1, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(-i, 1, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 1, i), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 1, -i), log);
        }
        this.doLeaves(reader, movablePos.m_7494_(), rand, branchWidth);
        return true;
    }

    private void doLeaves(WorldGenLevel reader, BlockPos pos, Random rand, int branchWidth) {
        int j;
        int i;
        BlockState leaves = ((Block)AoABlocks.SHADOWBLOOD_LEAVES.get()).m_49966_();
        for (i = -branchWidth - 1; i <= branchWidth + 1; ++i) {
            this.placeBlock(reader, pos.m_142082_(-i, 0, 0), leaves);
            if (Math.abs(i) > branchWidth && rand.nextInt(7) == 0) {
                this.doEyeHanger(reader, pos.m_142082_(i, 0, 0), rand);
            }
            for (j = 0; j <= branchWidth; ++j) {
                if (Math.abs(i) > branchWidth - j + 1) continue;
                this.placeBlock(reader, pos.m_142082_(i, 0, j + 1), leaves);
                this.placeBlock(reader, pos.m_142082_(-i, 0, -j - 1), leaves);
                if (i == 0) continue;
                if (rand.nextInt(7) == 0) {
                    this.doEyeHanger(reader, pos.m_142082_(i, 0, -j - 1), rand);
                }
                if (rand.nextInt(7) != 0) continue;
                this.doEyeHanger(reader, pos.m_142082_(i, 0, j + 1), rand);
            }
        }
        for (i = -branchWidth; i <= branchWidth; ++i) {
            for (j = 0; j <= branchWidth - Math.abs(i); ++j) {
                this.placeBlock(reader, pos.m_142082_(i, 1, j), leaves);
                this.placeBlock(reader, pos.m_142082_(i, 1, -j), leaves);
            }
        }
        if (branchWidth == 3) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, 2, z), leaves);
                }
            }
        }
    }

    private void doEyeHanger(WorldGenLevel reader, BlockPos leafPos, Random rand) {
        BlockState bloodStrands = ((Block)AoABlocks.BLOOD_STRANDS.get()).m_49966_();
        BlockState eye = ((Block)AoABlocks.EYE_BLOCK.get()).m_49966_();
        int length = 2 + rand.nextInt(3);
        for (int i = 1; i <= length; ++i) {
            this.placeBlock(reader, leafPos.m_6625_(i), bloodStrands);
        }
        this.placeBlock(reader, leafPos.m_6625_(length + 1), eye);
    }
}

