/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class LunossoTreeFeature
extends AoATreeFeature {
    public LunossoTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        switch (rand.nextInt(3)) {
            case 0: {
                return this.generateTree1(reader, rand, pos, isWorldGen);
            }
            case 1: {
                return this.generateTree2(reader, rand, pos, isWorldGen);
            }
        }
        return this.generateTree3(reader, rand, pos, isWorldGen);
    }

    private boolean generateTree1(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int y;
        int leafLoopWidth;
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (leafLoopWidth = 1 + rand.nextInt(2)) + 3, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        movablePos.m_122175_(Direction.UP, 2);
        int leafLoop = rand.nextInt(3);
        if (leafLoop == 2 || leafLoop == 0) {
            for (int x = -leafLoopWidth; x <= leafLoopWidth; ++x) {
                this.placeBlock(reader, movablePos.m_142082_(x, 0, 0), leaves);
                this.placeBlock(reader, movablePos.m_142082_(x, leafLoopWidth * 2, 0), leaves);
                if (Math.abs(x) != leafLoopWidth) continue;
                for (y = 1; y <= leafLoopWidth + 1; ++y) {
                    this.placeBlock(reader, movablePos.m_142082_(x, y, 0), leaves);
                }
            }
        }
        if (leafLoop == 2 || leafLoop == 1) {
            for (int z = -leafLoopWidth; z <= leafLoopWidth; ++z) {
                this.placeBlock(reader, movablePos.m_142082_(0, 0, z), leaves);
                this.placeBlock(reader, movablePos.m_142082_(0, leafLoopWidth * 2, z), leaves);
                if (Math.abs(z) != leafLoopWidth) continue;
                for (y = 1; y <= leafLoopWidth + 1; ++y) {
                    this.placeBlock(reader, movablePos.m_142082_(0, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int leafRings;
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (leafRings = 1 + rand.nextInt(3)) * 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        for (int y = 2; y <= leafRings * 2; y += 2) {
            int ringWidth = 1 + rand.nextInt(2);
            for (int x = -ringWidth; x <= ringWidth; ++x) {
                for (int z = -ringWidth; z <= ringWidth; ++z) {
                    if (Math.abs(x) != ringWidth && Math.abs(z) != ringWidth) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree3(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 3 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 8, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.LUNIDE_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.LUNOSSO_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        movablePos.m_122175_(Direction.UP, 5);
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (x * x + y * y + z * z != 9) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }
}

