/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class RunicTreeFeature
extends AoATreeFeature {
    public RunicTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        BlockPos multiSaplingPos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen);
        switch (rand.nextInt(multiSaplingPos != null ? 5 : 4)) {
            case 0: {
                return this.generateTree1(reader, rand, multiSaplingPos == null ? pos : multiSaplingPos, isWorldGen);
            }
            case 1: {
                return this.generateTree2(reader, rand, multiSaplingPos == null ? pos : multiSaplingPos, isWorldGen);
            }
            case 2: {
                return this.generateTree3(reader, rand, multiSaplingPos == null ? pos : multiSaplingPos, isWorldGen);
            }
            case 3: {
                return this.generateTree4(reader, rand, multiSaplingPos == null ? pos : multiSaplingPos, isWorldGen);
            }
            case 4: {
                return this.generateTree5(reader, rand, multiSaplingPos, isWorldGen);
            }
        }
        return false;
    }

    private boolean generateTree1(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int i;
        int leafHeight;
        int trunkHeight = 4 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (leafHeight = 2 + rand.nextInt(3)) - 1, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).m_49966_();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        this.placeBlock(reader, movablePos.m_142082_(1, 0, 0), log);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, 1), log);
        this.placeBlock(reader, movablePos.m_142082_(0, 0, -1), log);
        this.placeBlock(reader, movablePos.m_142082_(-1, 0, 0), log);
        this.placeBlock(reader, movablePos.m_142082_(1, 1, 0), log);
        this.placeBlock(reader, movablePos.m_142082_(0, 1, 1), log);
        this.placeBlock(reader, movablePos.m_142082_(0, 1, -1), log);
        this.placeBlock(reader, movablePos.m_142082_(-1, 1, 0), log);
        for (i = 0; i < leafHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), leaves);
        }
        return true;
    }

    private boolean generateTree2(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int i;
        int trunkHeight = 4 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 3, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).m_49966_();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        for (i = -2; i < 3; ++i) {
            if (i == 0) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 0, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 0, i), log);
            if (Math.abs(i) != 2) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 1, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 1, i), log);
        }
        int leafHeight = 2 + rand.nextInt(3);
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= leafHeight; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree3(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int i;
        int bulbWidth;
        int trunkHeight = 7 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (bulbWidth = 3 + rand.nextInt(2)) * 2 - 2, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).m_49966_();
        for (i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        for (i = -bulbWidth; i <= bulbWidth; ++i) {
            if (i == 0) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 0, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 0, i), log);
            if (Math.abs(i) != bulbWidth) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 1, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(i, 2, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 1, i), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 2, i), log);
        }
        for (int x = -bulbWidth + 1; x <= bulbWidth - 1; ++x) {
            for (int z = -bulbWidth + 1; z <= bulbWidth - 1; ++z) {
                for (int y = 1; y <= bulbWidth * 2 - 2; ++y) {
                    if ((y == 1 || y == bulbWidth * 2 - 2) && (Math.abs(x) == bulbWidth - 1 || Math.abs(z) == bulbWidth - 1)) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree4(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int trunkHeight = 9 + rand.nextInt(6);
        if (!this.checkSafeHeight(reader, pos, trunkHeight, 1, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 1, isWorldGen)) {
            return false;
        }
        BlockPos.MutableBlockPos movablePos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos.m_7495_());
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            this.placeBlock(reader, (BlockPos)movablePos.m_122173_(Direction.UP), log);
        }
        int branchHeight = 2 + rand.nextInt(3);
        for (int i = -4; i <= 4; ++i) {
            if (i == 0) continue;
            this.placeBlock(reader, movablePos.m_142082_(i, 0, 0), log);
            this.placeBlock(reader, movablePos.m_142082_(0, 0, i), log);
            if (Math.abs(i) != 4) continue;
            for (int j = 1; j <= branchHeight; ++j) {
                this.placeBlock(reader, movablePos.m_142082_(i, -j, 0), log);
                this.placeBlock(reader, movablePos.m_142082_(0, -j, i), log);
            }
        }
        for (int y = -1; y <= 1; ++y) {
            int width = 3 - Math.abs(y);
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    if (x * x + z * z > width * width) continue;
                    this.placeBlock(reader, movablePos.m_142082_(x, y - 2, z), leaves);
                }
            }
        }
        return true;
    }

    private boolean generateTree5(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        int z;
        int y;
        int x;
        int leafHeight;
        int trunkHeight = 4 + rand.nextInt(5);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + (leafHeight = 2 + rand.nextInt(5)) - 1, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x2 = 0; x2 < 2; ++x2) {
            for (int z2 = 0; z2 < 2; ++z2) {
                BlockPos testPos = pos.m_142082_(x2, -1, z2);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = ((Block)AoABlocks.RUNIC_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.RUNIC_LEAVES.get()).m_49966_();
        for (x = 0; x <= 1; ++x) {
            for (y = 0; y <= trunkHeight; ++y) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, y, z), log);
                }
            }
        }
        for (x = -1; x <= 2; ++x) {
            for (y = 0; y <= 1; ++y) {
                for (z = -1; z <= 2; ++z) {
                    if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                    this.placeBlock(reader, pos.m_142082_(x, trunkHeight + y, z), log);
                }
            }
        }
        for (x = 0; x <= 1; ++x) {
            for (y = 1; y <= leafHeight; ++y) {
                for (z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, trunkHeight + y, z), leaves);
                }
            }
        }
        return true;
    }
}

