/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.plant.SaplingBlock;
import net.tslat.aoa3.content.world.genold.feature.features.trees.AoATreeFeature;
import net.tslat.aoa3.content.world.genold.feature.placement.config.BlockStatePlacementConfig;

public class StranglewoodTreeFeature
extends AoATreeFeature {
    public StranglewoodTreeFeature(Codec<BlockStatePlacementConfig> codec, Supplier<SaplingBlock> saplingBlock) {
        super(codec, saplingBlock);
    }

    @Override
    protected boolean generateTree(WorldGenLevel reader, Random rand, BlockPos pos, boolean isWorldGen) {
        if ((pos = this.findMultiSaplingPosition(reader, rand, pos, 2, isWorldGen)) == null) {
            return false;
        }
        int trunkHeight = 10 + rand.nextInt(26);
        if (!this.checkSafeHeight(reader, pos, trunkHeight + 2, 2, isWorldGen)) {
            return false;
        }
        if (!this.checkAndPrepSoil(reader, pos, 2, isWorldGen)) {
            return false;
        }
        BlockState baseSoil = reader.m_8055_(pos.m_7495_());
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                BlockPos testPos = pos.m_142082_(x, -1, z);
                if (!reader.m_8055_(testPos).m_60713_(Blocks.f_50016_)) continue;
                reader.m_7731_(testPos, baseSoil, 2);
            }
        }
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).m_49966_();
        for (int i = 0; i < trunkHeight; ++i) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    this.placeBlock(reader, pos.m_142082_(x, i, z), log);
                }
            }
        }
        if (trunkHeight > 15) {
            this.buildTallCrown(reader, pos.m_6630_(trunkHeight - 1), rand);
        } else {
            this.buildShortCrown(reader, pos.m_6630_(trunkHeight - 1), rand);
            for (int x = -1; x <= 2; ++x) {
                for (int z = -1; z <= 2; ++z) {
                    if ((x == -1 || x == 2) && (z == -1 || z == 2)) continue;
                    this.placeBlock(reader, pos.m_142082_(x, trunkHeight - 3, z), leaves);
                }
            }
        }
        return true;
    }

    private void buildTallCrown(WorldGenLevel reader, BlockPos trunkTopPos, Random rand) {
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).m_49966_();
        for (int x = 0; x < 5; ++x) {
            this.placeBlock(reader, trunkTopPos.m_142082_(2 + x, 0, 0), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(2 + x, 0, 1), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(-x - 1, 0, 0), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(-x - 1, 0, 1), log);
        }
        for (int z = 0; z < 5; ++z) {
            this.placeBlock(reader, trunkTopPos.m_142082_(0, 0, 2 + z), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(1, 0, 2 + z), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(0, 0, -z - 1), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(1, 0, -z - 1), log);
        }
        this.buildTallNorthSouthLeaves(reader, trunkTopPos.m_142082_(0, 0, 6), rand);
        this.buildTallNorthSouthLeaves(reader, trunkTopPos.m_142082_(0, 0, -5), rand);
        this.buildTallEastWestLeaves(reader, trunkTopPos.m_142082_(-5, 0, 0), rand);
        this.buildTallEastWestLeaves(reader, trunkTopPos.m_142082_(6, 0, 0), rand);
    }

    private void buildTallNorthSouthLeaves(WorldGenLevel reader, BlockPos centralPos, Random rand) {
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).m_49966_();
        for (int x = -1; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    this.placeBlock(reader, centralPos.m_142082_(x, y, z), leaves);
                    if (y == 1 && z != -2 && z != 2) {
                        this.placeBlock(reader, centralPos.m_142082_(x, 2, z), leaves);
                        this.placeBlock(reader, centralPos.m_142082_(x, -2, z), leaves);
                    }
                    if (x != 0 || z == -2 || z == 2) continue;
                    this.placeBlock(reader, centralPos.m_142082_(-2, y, z), leaves);
                    this.placeBlock(reader, centralPos.m_142082_(3, y, z), leaves);
                }
            }
        }
    }

    private void buildTallEastWestLeaves(WorldGenLevel reader, BlockPos centralPos, Random rand) {
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).m_49966_();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 2; ++z) {
                    this.placeBlock(reader, centralPos.m_142082_(x, y, z), leaves);
                    if (y == 1 && x != -2 && x != 2) {
                        this.placeBlock(reader, centralPos.m_142082_(x, 2, z), leaves);
                        this.placeBlock(reader, centralPos.m_142082_(x, -2, z), leaves);
                    }
                    if (z != 0 || x == -2 || x == 2) continue;
                    this.placeBlock(reader, centralPos.m_142082_(x, y, -2), leaves);
                    this.placeBlock(reader, centralPos.m_142082_(x, y, 3), leaves);
                }
            }
        }
    }

    private void buildShortCrown(WorldGenLevel reader, BlockPos trunkTopPos, Random rand) {
        int i;
        BlockState log = ((Block)AoABlocks.STRANGLEWOOD_LOG.get()).m_49966_();
        BlockState leaves = ((Block)AoABlocks.STRANGLEWOOD_LEAVES.get()).m_49966_();
        for (i = 0; i < 4; ++i) {
            this.placeBlock(reader, trunkTopPos.m_142082_(i + 2, -4 + i, 0), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(i + 2, -4 + i, 1), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(0, -4 + i, i + 2), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(1, -4 + i, i + 2), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(-1 + -i, -4 + i, 0), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(-1 + -i, -4 + i, 1), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(0, -4 + i, -1 + -i), log);
            this.placeBlock(reader, trunkTopPos.m_142082_(1, -4 + i, -1 + -i), log);
        }
        for (i = 5; i > 2; --i) {
            for (int x2 = -i; x2 <= i + 1; ++x2) {
                for (int z2 = -i; z2 <= i + 1; ++z2) {
                    int x3 = x2;
                    int z3 = z2;
                    if (x3 < 0) {
                        --x3;
                    }
                    if (z3 < 0) {
                        --z3;
                    }
                    if (Math.abs(x3) > i - (Math.abs(z3) - 2)) continue;
                    this.placeBlock(reader, trunkTopPos.m_142082_(x2, 7 - i - 3, z2), leaves);
                }
            }
        }
    }
}

