/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityRetrievalUtil;
import net.tslat.aoa3.util.RandomUtil;

public class PixonSpawner
implements CustomSpawner {
    private static final HashMap<ResourceKey<Biome>, List<MobSpawnSettings.SpawnerData>> SPAWNS = new HashMap();
    private int spawnCooldown = 1200;

    public int m_7995_(ServerLevel world, boolean spawnHostiles, boolean spawnPassives) {
        if (this.spawnCooldown-- > 1200 || !spawnPassives || !world.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        if (RandomUtil.oneInNChance(Math.max(1, this.spawnCooldown))) {
            this.spawnCooldown = RandomUtil.randomNumberBetween(6000, 12000);
            return this.doSpawning(world);
        }
        return 0;
    }

    private int doSpawning(ServerLevel world) {
        int count = 0;
        for (ServerPlayer pl2 : world.m_8795_(pl -> !pl.m_5833_() && pl.m_6084_())) {
            for (Pair<EntityType<? extends Mob>, BlockPos> spawn : this.findNearbySpawnPositions(world, pl2.m_142538_(), 64, 10)) {
                int eventResult;
                BlockPos pos = (BlockPos)spawn.getSecond();
                Mob entity = (Mob)((EntityType)spawn.getFirst()).m_20655_(world, null, null, null, pos, MobSpawnType.NATURAL, false, false);
                if (entity == null || (eventResult = ForgeHooks.canEntitySpawn((Mob)entity, (LevelAccessor)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), null, (MobSpawnType)MobSpawnType.NATURAL)) == -1 || eventResult != 1 && (!entity.m_5545_((LevelAccessor)world, MobSpawnType.NATURAL) || !entity.m_6914_((LevelReader)world))) continue;
                world.m_7967_((Entity)entity);
                this.spawnCooldown += 1000;
                ++count;
            }
        }
        return count;
    }

    private List<Pair<EntityType<? extends Mob>, BlockPos>> findNearbySpawnPositions(ServerLevel world, BlockPos centerPos, int radius, int maxTries) {
        ArrayList<Pair<EntityType<? extends Mob>, BlockPos>> positions = new ArrayList<Pair<EntityType<? extends Mob>, BlockPos>>();
        for (int i = 0; i < maxTries; ++i) {
            int x = centerPos.m_123341_() + RandomUtil.randomNumberBetween(-radius, radius);
            int z = centerPos.m_123343_() + RandomUtil.randomNumberBetween(-radius, radius);
            BlockPos pos = new BlockPos(x, centerPos.m_123342_(), z);
            Biome biome = (Biome)world.m_204166_(pos).m_203334_();
            Optional key = ((Registry)world.m_142572_().m_206579_().m_6632_(Registry.f_122885_).get()).m_7854_((Object)biome);
            if (!key.isPresent() || !SPAWNS.containsKey(key.get())) continue;
            EntityType pixon = ((MobSpawnSettings.SpawnerData)WeightedRandom.m_146317_((Random)RandomUtil.RANDOM.source(), PixonSpawner.SPAWNS.get(key.get())).get()).f_48404_;
            SpawnPlacements.Type placementType = SpawnPlacements.m_21752_((EntityType)pixon);
            Heightmap.Types heightmap = SpawnPlacements.m_21765_((EntityType)pixon);
            pos = new BlockPos(x, world.m_5822_().nextInt(world.m_6924_(heightmap, x, z) + 1), z);
            if (EntityRetrievalUtil.getEntities((Level)world, new AABB((double)(x - 5), (double)(pos.m_123342_() - 5), (double)(z - 5), (double)(x + 5), (double)(pos.m_123342_() + 5), (double)(z + 5)), new EntityPredicate().is(pixon).isAlive()).size() > 3 || !NaturalSpawner.m_47051_((SpawnPlacements.Type)placementType, (LevelReader)world, (BlockPos)pos, (EntityType)pixon) || !world.m_45772_(pixon.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5))) continue;
            positions.add((Pair<EntityType<? extends Mob>, BlockPos>)Pair.of((Object)pixon, (Object)pos));
        }
        return positions;
    }

    public static void addSpawn(ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData spawnData) {
        if (SPAWNS.containsKey(biome)) {
            SPAWNS.get(biome).add(spawnData);
        } else {
            ArrayList<MobSpawnSettings.SpawnerData> spawnList = new ArrayList<MobSpawnSettings.SpawnerData>();
            spawnList.add(spawnData);
            SPAWNS.put(biome, spawnList);
        }
    }

    public static boolean isValidSpawnWorld(ServerLevel world) {
        ResourceKey key = world.m_46472_();
        return key == Level.f_46428_ || key == AoADimensions.HAVEN.key || key == AoADimensions.RUNANDOR.key || key == AoADimensions.CANDYLAND.key || key == AoADimensions.SHYRELANDS.key || key == AoADimensions.ABYSS.key || key == AoADimensions.DUSTOPIA.key || key == AoADimensions.LBOREAN.key || key == AoADimensions.LELYETIA.key || key == AoADimensions.MYSTERIUM.key;
    }
}

