/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.client.gui.realmstone.BlankRealmstoneScreen;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class RealmstoneInsertsReloadListener
implements ResourceManagerReloadListener {
    public static final HashMap<String, BlankRealmstoneScreen.RealmstoneWorldInsert> INSERTS = new HashMap();
    private static final Gson GSON = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        try {
            INSERTS.clear();
            for (ResourceLocation resourceLocation : resourceManager.m_6540_("realmstonegui", path -> path.endsWith(".json"))) {
                for (Resource resource : resourceManager.m_7396_(resourceLocation)) {
                    try {
                        InputStream stream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                            JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (json != null) {
                                BlankRealmstoneScreen.RealmstoneWorldInsert insert = BlankRealmstoneScreen.RealmstoneWorldInsert.fromJson(json);
                                INSERTS.put(insert.getId(), insert);
                                continue;
                            }
                            Logging.logMessage(Level.ERROR, "Realmstone insert json " + resource.m_7843_().toString() + " appears to be empty or null.");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (IOException | RuntimeException ex) {
                        Logging.logMessage(Level.ERROR, "Unable to deserialize realmstone insert json " + resourceLocation + ", skipping.", ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            for (BlankRealmstoneScreen.RealmstoneWorldInsert insert : INSERTS.values()) {
                for (String id : insert.getParents()) {
                    if (INSERTS.containsKey(id)) continue;
                    throw new IllegalArgumentException("Invalid parent node: " + id + " for realmstone insert " + insert.getId());
                }
            }
        }
        catch (IOException ex) {
            Logging.logMessage(Level.ERROR, "Failed to retrieve AoA3 realmstone insert resources, skipping.", ex);
        }
    }
}

