/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class EntityEvents {
    public static void preInit() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, EntityEvents::onEntityUpdate);
        forgeBus.addListener(EventPriority.NORMAL, false, EntityJoinWorldEvent.class, EntityEvents::onEntityJoinWorld);
        forgeBus.addListener(EventPriority.LOWEST, false, LivingSpawnEvent.SpecialSpawn.class, EntityEvents::onEntitySpawn);
        forgeBus.addListener(EventPriority.NORMAL, false, ExplosionEvent.Detonate.class, EntityEvents::onEntityExploded);
        forgeBus.addListener(EventPriority.NORMAL, false, VillagerTradesEvent.class, EntityEvents::onTraderGenTrades);
    }

    private static void onEntityUpdate(LivingEvent.LivingUpdateEvent ev) {
        if (ev.getEntityLiving().f_19853_.f_46443_ && ((Boolean)AoAConfig.CLIENT.partyDeaths.get()).booleanValue() && ev.getEntityLiving().f_20919_ >= 19) {
            AABB boundingBox = ev.getEntity().m_142469_();
            double width = boundingBox.f_82291_ - boundingBox.f_82288_;
            double depth = boundingBox.f_82293_ - boundingBox.f_82290_;
            double height = boundingBox.f_82292_ - boundingBox.f_82289_;
            int i = 0;
            while ((double)i < 3.0 + 10.0 * width * depth * height) {
                ev.getEntityLiving().f_19853_.m_7106_((ParticleOptions)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.RAINBOW_SPARKLER.get()), 0.03f, 3.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1), boundingBox.f_82288_ + RandomUtil.randomValueUpTo(width), boundingBox.f_82289_ + RandomUtil.randomValueUpTo(height), boundingBox.f_82290_ + RandomUtil.randomValueUpTo(depth), RandomUtil.randomScaledGaussianValue(0.05), 0.0, RandomUtil.randomScaledGaussianValue(0.05));
                ++i;
            }
        }
    }

    private static void onEntityJoinWorld(EntityJoinWorldEvent ev) {
        if (!ev.getWorld().f_46443_ && WorldUtil.isWorld(ev.getWorld(), AoADimensions.NETHER.key) && ev.getEntity() instanceof WitherBoss && ((WitherBoss)ev.getEntity()).m_31502_() == 220) {
            for (Player pl : ev.getWorld().m_45976_(Player.class, ev.getEntity().m_142469_().m_82400_(50.0))) {
                if (!ItemUtil.findInventoryItem(pl, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) continue;
                ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((ItemLike)AoAItems.ABYSS_REALMSTONE.get()));
            }
        }
    }

    private static void onEntitySpawn(LivingSpawnEvent.SpecialSpawn ev) {
        if (ev.getSpawnReason() == MobSpawnType.SPAWNER) {
            ev.getEntity().getPersistentData().m_128379_("spawned_by_spawner", true);
        }
    }

    private static void onEntityExploded(ExplosionEvent.Detonate ev) {
        if (((Boolean)AoAConfig.SERVER.saveLootFromExplosions.get()).booleanValue()) {
            ev.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity && entity.f_19797_ < 20);
        }
    }

    private static void onTraderGenTrades(VillagerTradesEvent ev) {
        if (ev.getType() == VillagerProfession.f_35588_) {
            ((List)ev.getTrades().get(1)).add(new VillagerTrades.TreasureMapForEmeralds(4, AoATags.ConfiguredStructures.ON_RUINED_TELEPORTER_FRAME_MAPS, "filled_map.aoa3.ruined_teleporter_frame", MapDecoration.Type.TARGET_POINT, 3, 7));
        }
    }
}

