/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.recipe.FrameBenchRecipe;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.content.recipe.ToolInteractionRecipe;
import net.tslat.aoa3.content.recipe.UpgradeKitRecipe;
import net.tslat.aoa3.content.recipe.WhitewashingRecipe;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.jei.ingredient.subtype.TrophySubtypeInterpreter;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.toolinteraction.ToolInteractionRecipeExtension;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeTransferInfo;
import net.tslat.aoa3.integration.tinkersconstruct.TinkersFluids;
import net.tslat.aoa3.util.FluidUtil;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("aoa3", "core");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ToolInteractionRecipe.class, ToolInteractionRecipeExtension::new);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)AoABlocks.DIVINE_STATION.get()), new RecipeType[]{UpgradeKitRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get()), new RecipeType[]{InfusionRecipeCategory.RECIPE_TYPE, ImbuingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)AoABlocks.FRAME_BENCH.get()), new RecipeType[]{FrameBenchRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)AoABlocks.WHITEWASHING_TABLE.get()), new RecipeType[]{WhitewashingRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new UpgradeKitRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new ImbuingRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new InfusionRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new FrameBenchRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new WhitewashingRecipeTransferInfo());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Minecraft.m_91087_().m_91403_() == null || !IntegrationManager.isJEIActive()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().m_91403_().m_105141_();
        registration.addRecipes(UpgradeKitRecipeCategory.RECIPE_TYPE, this.compileUpgradeKitRecipes(recipeManager));
        registration.addRecipes(ImbuingRecipeCategory.RECIPE_TYPE, this.compileImbuingRecipes(recipeManager));
        registration.addRecipes(InfusionRecipeCategory.RECIPE_TYPE, this.compileInfusionRecipes(recipeManager));
        registration.addRecipes(FrameBenchRecipeCategory.RECIPE_TYPE, this.compileFrameBenchRecipes(recipeManager));
        registration.addRecipes(WhitewashingRecipeCategory.RECIPE_TYPE, this.compileWhitewashingRecipes(recipeManager));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new UpgradeKitRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new ImbuingRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new InfusionRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FrameBenchRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new WhitewashingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.registerSubtypeInterpreter(((Block)AoABlocks.TROPHY.get()).m_5456_(), (IIngredientSubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(((Block)AoABlocks.GOLD_TROPHY.get()).m_5456_(), (IIngredientSubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(((Block)AoABlocks.ORNATE_TROPHY.get()).m_5456_(), (IIngredientSubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
    }

    private List<UpgradeKitRecipe> compileUpgradeKitRecipes(RecipeManager recipeManager) {
        return recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AoARecipes.UPGRADE_KIT.type().get());
    }

    private ArrayList<WhitewashingRecipe> compileWhitewashingRecipes(RecipeManager recipeManager) {
        ArrayList<WhitewashingRecipe> whitewashingRecipes = new ArrayList<WhitewashingRecipe>(10);
        whitewashingRecipes.add(new WhitewashingRecipe(new ResourceLocation("aoa3", "whitewashing_white"), (ItemLike)AoAItems.WHITEWASHING_SOLUTION.get(), (ItemLike)AoABlocks.WHITEWASH_BRICKS.get()));
        whitewashingRecipes.add(new WhitewashingRecipe(new ResourceLocation("aoa3", "whitewashing_dark"), (ItemLike)AoAItems.DARKLY_POWDER.get(), (ItemLike)AoABlocks.DARKWASH_BRICKS.get()));
        return whitewashingRecipes;
    }

    private ArrayList<FrameBenchRecipe> compileFrameBenchRecipes(RecipeManager recipeManager) {
        ArrayList<FrameBenchRecipe> frameRecipes = new ArrayList<FrameBenchRecipe>(10);
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_crossbow"), (ItemLike)AoAItems.CROSSBOW_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_blaster"), (ItemLike)AoAItems.BLASTER_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_cannon"), (ItemLike)AoAItems.CANNON_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_helmet"), (ItemLike)AoAItems.HELMET_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_chestplate"), (ItemLike)AoAItems.CHESTPLATE_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_leggings"), (ItemLike)AoAItems.LEGGINGS_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_boots"), (ItemLike)AoAItems.BOOTS_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_gun"), (ItemLike)AoAItems.GUN_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_shotgun"), (ItemLike)AoAItems.SHOTGUN_FRAME.get()));
        frameRecipes.add(new FrameBenchRecipe(new ResourceLocation("aoa3", "frame_bench_sniper"), (ItemLike)AoAItems.SNIPER_FRAME.get()));
        return frameRecipes;
    }

    private ArrayList<InfusionRecipe> compileImbuingRecipes(RecipeManager recipeManager) {
        ArrayList<InfusionRecipe> imbuingRecipes = new ArrayList<InfusionRecipe>();
        for (InfusionRecipe recipe : recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AoARecipes.INFUSION.type().get())) {
            if (!recipe.isEnchanting()) continue;
            imbuingRecipes.add(recipe);
        }
        return imbuingRecipes;
    }

    private ArrayList<InfusionRecipe> compileInfusionRecipes(RecipeManager recipeManager) {
        ArrayList<InfusionRecipe> infusionRecipes = new ArrayList<InfusionRecipe>();
        for (InfusionRecipe recipe : recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AoARecipes.INFUSION.type().get())) {
            if (recipe.isEnchanting()) continue;
            infusionRecipes.add(recipe);
        }
        return infusionRecipes;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        if (!IntegrationManager.isTinkersConstructActive()) {
            Function<FluidUtil.RegisteredFluidHolder, FluidStack> fluidStackGen = holder -> new FluidStack((Fluid)holder.fluid().get(), 1000);
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.FLUID, Arrays.asList(fluidStackGen.apply(TinkersFluids.MOLTEN_BARONYTE), fluidStackGen.apply(TinkersFluids.MOLTEN_BLAZIUM), fluidStackGen.apply(TinkersFluids.MOLTEN_ELECANIUM), fluidStackGen.apply(TinkersFluids.MOLTEN_EMBERSTONE), fluidStackGen.apply(TinkersFluids.MOLTEN_GHASTLY), fluidStackGen.apply(TinkersFluids.MOLTEN_GHOULISH), fluidStackGen.apply(TinkersFluids.MOLTEN_LIMONITE), fluidStackGen.apply(TinkersFluids.MOLTEN_LUNAR), fluidStackGen.apply(TinkersFluids.MOLTEN_LYON), fluidStackGen.apply(TinkersFluids.MOLTEN_MYSTITE), fluidStackGen.apply(TinkersFluids.MOLTEN_ROSITE), fluidStackGen.apply(TinkersFluids.MOLTEN_SHYRESTONE), fluidStackGen.apply(TinkersFluids.MOLTEN_SKELETAL), fluidStackGen.apply(TinkersFluids.MOLTEN_VARSIUM), fluidStackGen.apply(TinkersFluids.MOLTEN_CHARGER)));
        }
    }
}

