/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jer;

import java.util.function.Consumer;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IPlantRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.JERPlugin;
import jeresources.api.drop.PlantDrop;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import org.apache.commons.lang3.tuple.Triple;

public class JERIntegration {
    @JERPlugin
    public static IJERAPI jerAPI = null;

    public static void postInit() {
        if (jerAPI == null) {
            return;
        }
        JERIntegration.integrateDungeonLoot();
        JERIntegration.integrateCrops();
        JERIntegration.integrateWorldGen();
    }

    private static void integrateWorldGen() {
        IWorldGenRegistry worldGenRegistry = jerAPI.getWorldGenRegistry();
    }

    private static void integrateCrops() {
        IPlantRegistry plantRegistry = jerAPI.getPlantRegistry();
        Consumer<Triple> cropTableConsumer1 = objects -> plantRegistry.register(new ItemStack((ItemLike)objects.getRight()), (IPlantable)objects.getLeft(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)objects.getMiddle()), 1.0f), new PlantDrop(new ItemStack((ItemLike)objects.getRight()), 1.0f), new PlantDrop(new ItemStack((ItemLike)objects.getRight()), 1, 4)});
        Consumer<Tuple> cropTableConsumer2 = objects -> plantRegistry.register(new ItemStack((ItemLike)objects.m_14419_()), (IPlantable)objects.m_14418_(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)objects.m_14419_()), 1.0f), new PlantDrop(new ItemStack((ItemLike)objects.m_14419_()), 1, 4)});
        Consumer<Triple> cropTableConsumer3 = objects -> plantRegistry.register(new ItemStack((ItemLike)objects.getRight()), (IPlantable)objects.getLeft(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)objects.getMiddle()), 1.0f), new PlantDrop(new ItemStack((ItemLike)objects.getMiddle()), 1, 3)});
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.BUBBLE_BERRY_CROP.get()), (Object)((Item)AoAItems.BUBBLE_BERRIES.get()), (Object)((Item)AoAItems.BUBBLE_BERRY_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.CHILLI_CROP.get()), (Object)((Item)AoAItems.CHILLI.get()), (Object)((Item)AoAItems.CHILLI_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.FLORACLES_CROP.get()), (Object)((Item)AoAItems.FLORACLE_STICKS.get()), (Object)((Item)AoAItems.FLORACLE_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.GOLDICAPS_CROP.get()), (Object)((Item)AoAItems.GOLDICAP_PETALS.get()), (Object)((Item)AoAItems.GOLDICAP_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.LUNACRIKE_CROP.get()), (Object)((Item)AoAItems.LUNACRIKE.get()), (Object)((Item)AoAItems.LUNACRIKE_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.LUNA_GLOBE_CROP.get()), (Object)((Item)AoAItems.LUNA_GLOBE.get()), (Object)((Item)AoAItems.LUNA_GLOBE_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.LUNALON_CROP.get()), (Object)((Item)AoAItems.LUNALONS.get()), (Object)((Item)AoAItems.LUNALON_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.ROSIDON_CROP.get()), (Object)((Item)AoAItems.ROSIDONS.get()), (Object)((Item)AoAItems.ROSIDON_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.TEA_CROP.get()), (Object)((Item)AoAItems.TEA_SHREDDINGS.get()), (Object)((Item)AoAItems.TEA_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.THORNY_PLANT_CROP.get()), (Object)((Item)AoAItems.THORNY_PETALS.get()), (Object)((Item)AoAItems.THORNY_PLANT_SEEDS.get())));
        cropTableConsumer1.accept(Triple.of((Object)((IPlantable)AoABlocks.TRILLIAD_CROP.get()), (Object)((Item)AoAItems.TRILLIAD_LEAVES.get()), (Object)((Item)AoAItems.TRILLIAD_SEEDS.get())));
        cropTableConsumer2.accept(new Tuple((Object)((IPlantable)AoABlocks.EYE_BULB_CROP.get()), (Object)((Item)AoAItems.EYE_BULB.get())));
        cropTableConsumer2.accept(new Tuple((Object)((IPlantable)AoABlocks.MYSTIC_SHROOM_CROP.get()), (Object)((Item)AoAItems.MYSTIC_SHROOMS.get())));
        cropTableConsumer3.accept(Triple.of((Object)((IPlantable)AoABlocks.HEART_FRUIT_CROP.get()), (Object)((Item)AoAItems.HEART_FRUIT.get()), (Object)((Item)AoAItems.HEART_FRUIT_SEEDS.get())));
        plantRegistry.register(new ItemStack((ItemLike)AoAItems.MAGIC_MARANG.get()), (IPlantable)AoABlocks.MAGIC_MARANG_CROP.get(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)AoAItems.MAGIC_MARANG.get()), 1.0f)});
    }

    private static void integrateDungeonLoot() {
        IDungeonRegistry dungeonRegistry = jerAPI.getDungeonRegistry();
        dungeonRegistry.registerChest("Aquatic Castle", new ResourceLocation("aoa3", "structures/aquatic_castle"));
        dungeonRegistry.registerChest("Baron Castle", new ResourceLocation("aoa3", "structures/baron_castle"));
        dungeonRegistry.registerChest("Floro Castle", new ResourceLocation("aoa3", "structures/floro_castle"));
        dungeonRegistry.registerChest("Garden Castle", new ResourceLocation("aoa3", "structures/garden_castle"));
        dungeonRegistry.registerChest("Gingerbread House", new ResourceLocation("aoa3", "structures/gingerbread_house"));
        dungeonRegistry.registerChest("Guardian Tower", new ResourceLocation("aoa3", "structures/guardian_tower"));
        dungeonRegistry.registerChest("Haunted Castle", new ResourceLocation("aoa3", "structures/haunted_castle_top_floor"));
        dungeonRegistry.registerChest("Iro Passages", new ResourceLocation("aoa3", "structures/iro_passage"));
        dungeonRegistry.registerChest("Lelyetian Tower", new ResourceLocation("aoa3", "structures/lelyetian_tower"));
        dungeonRegistry.registerChest("Lunar Food Market", new ResourceLocation("aoa3", "structures/lunar_food_market"));
        dungeonRegistry.registerChest("Lunarade Stand", new ResourceLocation("aoa3", "structures/lunarade_stand"));
        dungeonRegistry.registerChest("Spellbinder House", new ResourceLocation("aoa3", "structures/spellbinder_house"));
    }
}

