/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.leaderboard.task;

import com.mojang.datafixers.util.Pair;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.leaderboard.connection.InsertionConnection;
import net.tslat.aoa3.leaderboard.task.InsertionTask;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import org.apache.logging.log4j.Level;

public class AddPlayerTask
extends InsertionTask {
    private final String uuid;
    private final String name;
    private final ArrayList<Pair<AoASkill, Short>> skills = new ArrayList();
    private int totalLevel = 0;

    public AddPlayerTask(ServerPlayerDataManager plData) {
        this.uuid = plData.player().m_142081_().toString();
        this.name = plData.player().m_7755_().getString();
        for (AoASkill.Instance skill : plData.getSkills()) {
            int level = skill.getLevel(true);
            this.totalLevel += level;
            this.skills.add((Pair<AoASkill, Short>)Pair.of((Object)((Object)skill.type()), (Object)((short)level)));
        }
    }

    @Override
    public void execute(Connection connection, InsertionConnection leaderboardConnection) {
        this.beginBatchUpdate(connection);
        try {
            leaderboardConnection.updatePlayerTotal(connection, this.uuid, this.name, this.totalLevel);
            for (Pair<AoASkill, Short> skill : this.skills) {
                leaderboardConnection.updatePlayerLevel(connection, this.uuid, this.name, (AoASkill)((Object)skill.getFirst()), (Short)skill.getSecond());
            }
        }
        catch (SQLException ex) {
            Logging.logMessage(Level.WARN, "Unable to prepare statement for execution to add " + this.name + " to the skills leaderboard. This is probably not a good sign", ex);
        }
        this.endBatchUpdate(connection);
    }
}

