/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.leaderboard.task;

import java.sql.Connection;
import java.sql.SQLException;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.leaderboard.connection.InsertionConnection;
import net.tslat.aoa3.leaderboard.task.InsertionTask;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import org.apache.logging.log4j.Level;

public class UpdatePlayerTask
extends InsertionTask {
    private final String uuid;
    private final String name;
    private final AoASkill skill;
    private final short level;
    private int newTotal;

    public UpdatePlayerTask(ServerPlayerDataManager plData, AoASkill.Instance skill) {
        this.uuid = plData.player().m_142081_().toString();
        this.name = plData.player().m_7755_().getString();
        this.skill = skill.type();
        this.level = (short)skill.getLevel(true);
        for (AoASkill.Instance instance : plData.getSkills()) {
            this.newTotal += instance.getLevel(true);
        }
    }

    @Override
    public void execute(Connection connection, InsertionConnection leaderboardConnection) {
        try {
            leaderboardConnection.updatePlayerTotal(connection, this.uuid, this.name, this.newTotal);
            leaderboardConnection.updatePlayerLevel(connection, this.uuid, this.name, this.skill, this.level);
        }
        catch (SQLException ex) {
            Logging.logMessage(Level.WARN, "Unable to prepare statement for execution to update " + this.name + " in skills leaderboard. This is probably not a good sign", ex);
        }
    }

    @Override
    protected boolean requiresCompletion() {
        return true;
    }
}

