/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.builder;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class PotionBuilder {
    Item potionItem;
    String displayName = null;
    boolean translatable = false;
    ArrayList<MobEffectInstance> effects = null;
    Integer colour = null;
    boolean dynamicColour = true;

    public PotionBuilder(Item potionItem) {
        this.potionItem = potionItem;
    }

    public PotionBuilder withName(String name) {
        this.displayName = name;
        return this;
    }

    public PotionBuilder withTranslationKey(String nameLangKey) {
        this.displayName = nameLangKey;
        this.translatable = true;
        return this;
    }

    public PotionBuilder addEffect(MobEffectInstance effect) {
        if (this.effects == null) {
            this.effects = new ArrayList(1);
        }
        this.effects.add(effect);
        return this;
    }

    public PotionBuilder withColour(int colour) {
        this.colour = Integer.parseInt(String.valueOf(colour), 16);
        this.dynamicColour = false;
        return this;
    }

    public ItemStack build() {
        ItemStack stack = new ItemStack((ItemLike)this.potionItem);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag displayTag = stack.m_41698_("display");
        if (this.displayName != null) {
            stack.m_41714_((Component)(this.translatable ? new TranslatableComponent(this.displayName) : new TextComponent(this.displayName)));
        }
        if (this.dynamicColour && this.effects != null) {
            this.colour = PotionUtils.m_43564_(this.effects);
        }
        if (this.colour != null) {
            nbt.m_128359_("CustomPotionColor", String.valueOf(this.colour));
        }
        if (this.effects != null && !this.effects.isEmpty()) {
            PotionUtils.m_43552_((ItemStack)stack, this.effects);
        }
        if (!displayTag.m_128456_()) {
            nbt.m_128365_("display", (Tag)displayTag);
        }
        return stack;
    }
}

