/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.constant;

import net.tslat.aoa3.util.RandomUtil;

public class ScreenImageEffect {
    private final Type type;
    private float rotation = 0.0f;
    private float scale = 1.0f;
    private int colour = 0;
    private int duration = 60;
    private int durationRemaining = 60;
    private int x = 0;
    private int y = 0;

    public ScreenImageEffect(Type type) {
        this.type = type;
    }

    public ScreenImageEffect rotated(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public ScreenImageEffect randomRotation() {
        return this.rotated((float)RandomUtil.randomValueBetween(-180.0, 179.0));
    }

    public ScreenImageEffect scaled(float scale) {
        this.scale = scale;
        return this;
    }

    public ScreenImageEffect randomScale() {
        return this.scaled((float)RandomUtil.randomValueBetween(0.25, 1.25));
    }

    public ScreenImageEffect coloured(int colour) {
        this.colour = colour;
        return this;
    }

    public ScreenImageEffect duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public void tickDown() {
        --this.durationRemaining;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScale() {
        return this.scale;
    }

    public int getColour() {
        return this.colour;
    }

    public int getDuration() {
        return this.duration;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        SCRATCH("textures/gui/overlay/effect/scratch", 4),
        BLOOD("textures/gui/overlay/effect/splat", 4);

        public final String path;
        public final int variants;

        private Type(String path, int variants) {
            this.path = path;
            this.variants = variants;
        }
    }
}

