/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;

public class IntValueProvider {
    public static final Codec<IntValueProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.optionalFieldOf("min", (Object)0).forGetter(config -> config.min), (App)Codec.INT.optionalFieldOf("max", (Object)0).forGetter(config -> config.max)).apply((Applicative)builder, IntValueProvider::new));
    public final int min;
    public final int max;

    public IntValueProvider(int value) {
        this.min = value;
        this.max = value;
    }

    public IntValueProvider(int min, int max) {
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public int getValue(Random rand) {
        if (this.min == this.max) {
            return this.max;
        }
        return rand.nextInt(1 + this.max - this.min) + this.min;
    }
}

