/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class AutoEnchantCrafting
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.ITEM_CRAFTING};
    private final EnchantmentInstance[] enchantments;

    public AutoEnchantCrafting(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.AUTO_ENCHANT_CRAFTING.get()), skill, data);
        JsonObject enchantMap = data.getAsJsonObject("enchantments");
        this.enchantments = new EnchantmentInstance[enchantMap.size()];
        int i = 0;
        for (Map.Entry entry : enchantMap.entrySet()) {
            this.enchantments[i] = new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsInt());
            ++i;
        }
        if (this.enchantments.length == 0) {
            throw new IllegalArgumentException("No valid enchantments found for AutoEnchantCrafting ability, ID: '" + this.getUniqueIdentifier() + "'");
        }
    }

    public AutoEnchantCrafting(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.AUTO_ENCHANT_CRAFTING.get()), skill, data);
        CompoundTag enchantMap = data.m_128469_("enchantments");
        this.enchantments = new EnchantmentInstance[enchantMap.m_128440_()];
        int i = 0;
        for (String enchantId : enchantMap.m_128431_()) {
            this.enchantments[i] = new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantId)), enchantMap.m_128451_(enchantId));
            ++i;
        }
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        boolean comma = false;
        for (EnchantmentInstance enchants : this.enchantments) {
            if (comma) {
                defaultDescription.m_130946_(", ");
            }
            defaultDescription.m_7220_(enchants.f_44947_.m_44700_(enchants.f_44948_));
            comma = true;
        }
        super.updateDescription(defaultDescription);
    }

    @Override
    public void handleItemCrafting(ItemCraftingEvent ev) {
        ItemStack output = ev.getOutputStack();
        for (EnchantmentInstance data : this.enchantments) {
            if (data.f_44947_.canApplyAtEnchantingTable(output)) continue;
            return;
        }
        for (EnchantmentInstance data : this.enchantments) {
            output.m_41663_(data.f_44947_, data.f_44948_);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            CompoundTag enchantMap = new CompoundTag();
            for (EnchantmentInstance enchantData : this.enchantments) {
                enchantMap.m_128405_(enchantData.f_44947_.getRegistryName().toString(), enchantData.f_44948_);
            }
            data.m_128365_("enchantments", (Tag)enchantMap);
        }
        return data;
    }
}

