/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.container.SelectInventoryItemScreen;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.SyncAoAAbilityDataPacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class AutoHarvestingTrash
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.LOOT_MODIFICATION};
    @Nullable
    private Item consumingItem = null;

    public AutoHarvestingTrash(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.AUTO_HARVESTING_TRASH.get()), skill, data);
    }

    public AutoHarvestingTrash(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.AUTO_HARVESTING_TRASH.get()), skill, data);
        String itemId = data.m_128461_("item");
        this.consumingItem = itemId.isEmpty() ? null : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        TranslatableComponent description = defaultDescription;
        if (this.consumingItem != null) {
            description = new TranslatableComponent(defaultDescription.m_131328_() + ".item", new Object[]{new TranslatableComponent(this.consumingItem.m_5456_().m_5524_()).m_130940_(ChatFormatting.GRAY)});
        }
        super.updateDescription(description);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleLootModification(List<ItemStack> loot, LootContext context) {
        if (this.consumingItem != null && context.m_78953_(LootContextParams.f_81461_) != null) {
            loot.removeIf(stack -> stack.m_41720_() == this.consumingItem);
        }
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        if (data.m_128441_("item")) {
            this.consumingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.m_128461_("item")));
            this.updateDescription(new TranslatableComponent(Util.m_137492_((String)"ability", (ResourceLocation)this.type().getRegistryName()) + ".description"));
            this.markForClientSync();
        }
    }

    @Override
    public CompoundTag saveToNbt() {
        CompoundTag data = super.saveToNbt();
        if (this.consumingItem != null) {
            data.m_128359_("item", this.consumingItem.getRegistryName().toString());
        }
        return data;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        data.m_128359_("item", this.consumingItem != null ? this.consumingItem.getRegistryName().toString() : "");
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        super.receiveSyncData(data);
        this.consumingItem = data.m_128461_("item").equals("") ? null : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.m_128461_("item")));
        this.updateDescription(new TranslatableComponent(Util.m_137492_((String)"ability", (ResourceLocation)this.type().getRegistryName()) + ".description"));
    }

    @Override
    public void receiveInteractionDataFromClient(String data) {
        this.consumingItem = data.equals(Items.f_41852_.getRegistryName().toString()) ? null : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data));
        this.markForClientSync();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiClick(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (ClientOperations.isPressingCrouchKey()) {
            ForgeHooksClient.pushGuiLayer((Minecraft)mc, (Screen)new SelectInventoryItemScreen(mc, this.consumingItem, item -> AoAPackets.messageServer(new SyncAoAAbilityDataPacket(this, item.getRegistryName().toString()))));
            return false;
        }
        return super.onGuiClick(mouseX, mouseY);
    }
}

