/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class DoubleJump
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.KEY_INPUT, AoAPlayerEventListener.ListenerType.PLAYER_FALL};
    private final float energyConsumption;
    private boolean canJump = true;

    public DoubleJump(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.DOUBLE_JUMP.get()), skill, data);
        this.energyConsumption = Math.max(0.0f, GsonHelper.m_13915_((JsonObject)data, (String)"energy_consumption"));
    }

    public DoubleJump(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.DOUBLE_JUMP.get()), skill, data);
        this.energyConsumption = data.m_128457_("energy_consumption");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        super.updateDescription(new TranslatableComponent(defaultDescription.m_131328_(), new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyConsumption, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeybind() {
        return Minecraft.m_91087_().f_91066_.f_92089_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSendKeyPress() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20096_() || player.f_36098_ > 0) {
            return false;
        }
        if (player.m_6844_(EquipmentSlot.CHEST).canElytraFly((LivingEntity)player)) {
            return false;
        }
        if (!player.m_7500_()) {
            player.f_36098_ = 7;
        }
        return true;
    }

    @Override
    public void handleKeyInput() {
        ServerPlayer player = this.getPlayer();
        if (this.canJump || player.m_7500_()) {
            if (player.m_20096_()) {
                return;
            }
            if (this.consumeResource((AoAResource)((Object)AoAResources.ENERGY.get()), this.energyConsumption, true)) {
                this.canJump = false;
                player.m_6135_();
                AoAPackets.messagePlayer(player, new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.SET).y(Float.valueOf((float)player.m_20184_().m_7098_())));
                if (this.getSkill().canGainXp(true)) {
                    this.getSkill().adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.getSkill().getLevel(true), 16.0f), false, false);
                }
            }
        }
    }

    @Override
    public void handlePlayerFall(LivingFallEvent ev) {
        if (!this.canJump) {
            ev.setDistance(ev.getDistance() - ev.getEntityLiving().m_6118_() * 10.0f);
        }
        this.canJump = true;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag syncData = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            syncData.m_128350_("energy_consumption", this.energyConsumption);
        }
        return syncData;
    }
}

