/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class FlatXpBoost
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.GAIN_SKILL_XP};
    private final float modifier;

    public FlatXpBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)((Object)AoAAbilities.FLAT_XP_BOOST.get()), skill, data);
        this.modifier = GsonHelper.m_13915_((JsonObject)data, (String)"modifier");
    }

    public FlatXpBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)((Object)AoAAbilities.FLAT_XP_BOOST.get()), skill, data);
        this.modifier = data.m_128457_("modifier");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        super.updateDescription(new TranslatableComponent(defaultDescription.m_131328_(), new Object[]{this.skill.getName(), NumberUtil.roundToNthDecimalPlace(this.modifier - 1.0f, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleSkillXpGain(PlayerChangeXpEvent ev) {
        ev.setXpGain(ev.getNewXpGain() * this.modifier);
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("modifier", this.modifier);
        }
        return data;
    }
}

