/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.library.object.DynamicTextComponent;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RandomUtil;

public abstract class ScalableModAbility
extends AoAAbility.Instance {
    protected final float baseValue;
    protected final float perLevelMod;

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, JsonObject data) {
        super(ability, skill, data);
        this.baseValue = GsonHelper.m_13820_((JsonObject)data, (String)"base_value", (float)0.0f);
        this.perLevelMod = GsonHelper.m_13820_((JsonObject)data, (String)"per_level_mod", (float)0.0f);
    }

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, CompoundTag data) {
        super(ability, skill, data);
        this.baseValue = data.m_128457_("base_value");
        this.perLevelMod = data.m_128457_("per_level_mod");
    }

    @Override
    protected void updateDescription(TranslatableComponent defaultDescription) {
        String defaultKey = Util.m_137492_((String)"ability", (ResourceLocation)this.type().getRegistryName()) + ".description";
        if (defaultDescription.m_131328_().equals(defaultKey) && defaultDescription.m_131329_().length == 0) {
            TranslatableComponent component = new TranslatableComponent(defaultDescription.m_131328_(), new Object[]{this.getScalingDescriptionComponent(4)});
            for (Component child : defaultDescription.m_7360_()) {
                component.m_7220_(child);
            }
            super.updateDescription(component);
            return;
        }
        super.updateDescription(defaultDescription);
    }

    protected TranslatableComponent getScalingDescriptionComponent(int precision) {
        return LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.isPercent(), NumberUtil.roundToNthDecimalPlace(this.baseValue * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.perLevelMod * (float)(this.isPercent() ? 100 : 1), precision), (Object)new DynamicTextComponent(() -> NumberUtil.roundToNthDecimalPlace(this.getScaledValue() * (float)(this.isPercent() ? 100 : 1), precision)));
    }

    protected boolean isPercent() {
        return true;
    }

    protected boolean testAsChance() {
        return RandomUtil.percentChance(this.getScaledValue());
    }

    protected float getScaledValue() {
        if (this.perLevelMod == 0.0f) {
            return this.baseValue;
        }
        return this.baseValue + (float)this.skill.getLevel(false) * this.perLevelMod;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("base_value", this.baseValue);
            data.m_128350_("per_level_mod", this.perLevelMod);
        }
        return data;
    }
}

