/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;

public class RageResource
extends AoAResource.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.INCOMING_ATTACK_DURING, AoAPlayerEventListener.ListenerType.PLAYER_TICK};
    private final float maxValue;
    private final float perTickDrain;
    private float value = 0.0f;

    public RageResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)((Object)AoAResources.RAGE.get()), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.m_13915_((JsonObject)jsonData, (String)"max_value"));
        this.perTickDrain = GsonHelper.m_13915_((JsonObject)jsonData, (String)"per_tick_drain");
    }

    public RageResource(CompoundTag nbtData) {
        super((AoAResource)((Object)AoAResources.RAGE.get()), null);
        this.maxValue = nbtData.m_128457_("max_value");
        this.perTickDrain = nbtData.m_128457_("per_tick_drain");
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.m_14036_((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void handleIncomingAttack(LivingHurtEvent ev) {
        if (ev.getSource().m_7639_() != null) {
            this.value = Math.min(this.getMaxValue(), this.value + ev.getAmount());
        }
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        if (this.value > 0.0f) {
            this.value -= this.perTickDrain;
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag nbt = new CompoundTag();
        if (forClientSetup) {
            nbt.m_128350_("max_value", this.maxValue);
            nbt.m_128350_("per_tick_drain", this.perTickDrain);
        } else {
            nbt.m_128350_("value", this.getCurrentValue());
        }
        return nbt;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        this.value = data.m_128457_("value");
    }
}

