/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class ExtractionSkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.LOOT_MODIFICATION, AoAPlayerEventListener.ListenerType.ITEM_SMELTED};

    public ExtractionSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)((Object)AoASkills.EXTRACTION.get()), plData, jsonData);
    }

    public ExtractionSkill(CompoundTag nbtData) {
        super((AoASkill)((Object)AoASkills.EXTRACTION.get()), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleLootModification(List<ItemStack> loot, LootContext context) {
        if (!this.canGainXp(true)) {
            return;
        }
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state == null) {
            return;
        }
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (origin == null) {
            return;
        }
        ServerLevel world = context.m_78952_();
        BlockPos pos = new BlockPos(origin);
        Block block = state.m_60734_();
        if (!Block.m_49916_((VoxelShape)state.m_60812_((BlockGetter)context.m_78952_(), pos))) {
            return;
        }
        if (!ExtractionSkill.isApplicableBlock(state)) {
            return;
        }
        float hardness = state.m_60800_((BlockGetter)world, pos);
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 2.0f * hardness);
        for (ItemStack item : loot) {
            if (item.m_41720_() == block.m_5456_()) continue;
            xp *= 2.0f;
            break;
        }
        if (loot.size() > 2) {
            xp *= 1.5f;
        }
        this.adjustXp(xp, false, false);
    }

    @Override
    public void handleItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (ev.getPlayer().f_19853_.m_5776_()) {
            return;
        }
        ItemStack smelting = ev.getSmelting();
        Item item = smelting.m_41720_();
        if (item.m_41473_() == null && this.canGainXp(true)) {
            float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 40.0f);
            if (smelting.m_204117_(Tags.Items.NUGGETS)) {
                xp *= 1.5f;
            } else if (smelting.m_204117_(Tags.Items.INGOTS)) {
                xp *= 2.0f;
            } else if (smelting.m_204117_(Tags.Items.GEMS)) {
                xp *= 2.5f;
            }
            this.adjustXp(xp, false, false);
        }
    }

    public static boolean isApplicableBlock(BlockState block) {
        return block.m_204336_(Tags.Blocks.STONE) || block.m_204336_(Tags.Blocks.COBBLESTONE) || block.m_204336_(Tags.Blocks.ORES) || block.m_204336_(BlockTags.f_13106_) || block.m_204336_(Tags.Blocks.SAND) || block.m_204336_(AoATags.Blocks.GRASS) || block.m_204336_(BlockTags.f_144274_) || block.m_204336_(Tags.Blocks.GRAVEL) || block.m_204336_(Tags.Blocks.NETHERRACK) || block.m_204336_(Tags.Blocks.OBSIDIAN);
    }
}

