/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class FaunamancySkill
extends AoASkill.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.OUTGOING_ATTACK_AFTER};

    public FaunamancySkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)((Object)AoASkills.FAUNAMANCY.get()), plData, jsonData);
    }

    public FaunamancySkill(CompoundTag nbtData) {
        super((AoASkill)((Object)AoASkills.FAUNAMANCY.get()), nbtData);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handlePostOutgoingAttack(LivingDamageEvent ev) {
        if (this.canGainXp(true) && FaunamancySkill.isValidSacrifice(ev.getEntityLiving(), this.getPlayer())) {
            this.adjustXp(PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), (int)(ev.getEntityLiving().m_21233_() / 30.0f * 20.0f)), false, false);
        }
    }

    public static boolean isValidSacrifice(LivingEntity target, Player attacker) {
        if (target.m_21223_() > 0.0f) {
            return false;
        }
        if (!attacker.m_21205_().m_204117_(AoATags.Items.FAUNAMANCER_TOOL)) {
            return false;
        }
        Vec3 targetVelocity = target.m_20184_();
        return targetVelocity.m_7096_() == 0.0 && targetVelocity.m_7094_() == 0.0 && !NumberUtil.numberIsBetween(targetVelocity.m_7098_(), -0.08, -0.07);
    }
}

