/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.WorldUtil;

public class CreepSpawnTask
implements Runnable {
    private final Level world;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private int currentCorner;
    private int count = 0;

    public CreepSpawnTask(Level w, double centerX, double centerY, double centerZ, int startingPosition) {
        this.world = w;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.currentCorner = startingPosition;
    }

    @Override
    public void run() {
        double x = this.centerX;
        double z = this.centerZ;
        switch (this.currentCorner) {
            case 0: {
                x += 9.0;
                z += 9.0;
                break;
            }
            case 1: {
                x -= 9.0;
                z += 9.0;
                break;
            }
            case 2: {
                x -= 9.0;
                z -= 9.0;
                break;
            }
            case 3: {
                x += 9.0;
                z -= 9.0;
            }
        }
        WorldUtil.createExplosion(null, this.world, x, this.centerY, z, 1.5f, Explosion.BlockInteraction.DESTROY);
        ++this.count;
        if (this.count >= 4) {
            return;
        }
        ++this.currentCorner;
        if (this.currentCorner > 3) {
            this.currentCorner = 0;
        }
        this.schedule(2, TimeUnit.SECONDS);
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

