/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class KrorSpawnTask
implements Runnable {
    private final ServerPlayer player;
    private final Level world;
    private final BlockPos chargingTablePos;
    private int chargedAmount = 0;

    public KrorSpawnTask(ServerPlayer player, BlockPos pos) {
        this.player = player;
        this.world = player.f_19853_;
        this.chargingTablePos = pos;
    }

    @Override
    public void run() {
        if (this.player.f_19853_ != this.world || this.player.m_20275_((double)this.chargingTablePos.m_123341_(), (double)this.chargingTablePos.m_123342_(), (double)this.chargingTablePos.m_123343_()) > 100.0) {
            return;
        }
        if (this.world.m_46791_() == Difficulty.PEACEFUL) {
            this.player.m_6352_((Component)LocaleUtil.getLocaleMessage("message.feedback.spawnBoss.difficultyFail"), Util.f_137441_);
            return;
        }
        if (this.world.m_8055_(this.chargingTablePos).m_60734_() != AoABlocks.CHARGING_TABLE.get()) {
            return;
        }
        if (this.chargedAmount < 200) {
            if (PlayerUtil.consumeResource(this.player, (AoAResource)((Object)AoAResources.SPIRIT.get()), 20.0f, false)) {
                this.chargedAmount += 20;
                ((ServerLevel)this.world).m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)this.chargingTablePos.m_123341_() + 0.5, (double)this.chargingTablePos.m_123342_() + 0.9, (double)this.chargingTablePos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)this.world).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.player.m_20185_(), this.player.m_142469_().f_82292_ + 0.5, this.player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.schedule(1, TimeUnit.SECONDS);
            } else {
                PlayerUtil.notifyPlayerOfInsufficientResources(this.player, (AoAResource)((Object)AoAResources.SPIRIT.get()), 20.0f);
            }
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

