/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public final class BrainUtils {
    public static <T> T memoryOrDefault(LivingEntity entity, MemoryModuleType<T> memory, @Nullable T fallback) {
        return BrainUtils.memoryOrDefault(entity.m_6274_(), memory, fallback);
    }

    public static <T> T memoryOrDefault(Brain<?> brain, MemoryModuleType<T> memory, @Nullable T fallback) {
        return brain.m_21952_(memory).orElse(fallback);
    }

    public static <T> Optional<T> getOptionalMemory(LivingEntity entity, MemoryModuleType<T> memory) {
        return BrainUtils.getOptionalMemory(entity, memory, Optional.empty());
    }

    public static <T> Optional<T> getOptionalMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        return BrainUtils.getOptionalMemory(brain, memory, Optional.empty());
    }

    public static <T> Optional<T> getOptionalMemory(LivingEntity entity, MemoryModuleType<T> memory, Optional<T> fallback) {
        return BrainUtils.getOptionalMemory(entity.m_6274_(), memory, fallback);
    }

    public static <T> Optional<T> getOptionalMemory(Brain<?> brain, MemoryModuleType<T> memory, Optional<T> fallback) {
        Optional<T> storedMemory = brain.m_21952_(memory);
        return storedMemory.isPresent() ? storedMemory : fallback;
    }

    @Nullable
    public static <T> T getMemory(LivingEntity entity, MemoryModuleType<T> memory) {
        return BrainUtils.getMemory(entity.m_6274_(), memory);
    }

    @Nullable
    public static <T> T getMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        return BrainUtils.memoryOrDefault(brain, memory, null);
    }

    public static <T> void withMemory(LivingEntity entity, MemoryModuleType<T> memory, Consumer<T> consumer) {
        BrainUtils.withMemory(entity.m_6274_(), memory, consumer);
    }

    public static <T> void withMemory(Brain<?> brain, MemoryModuleType<T> memory, Consumer<T> consumer) {
        brain.m_21952_(memory).ifPresent(consumer);
    }

    public static boolean hasMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        return BrainUtils.hasMemory(entity.m_6274_(), memory);
    }

    public static boolean hasMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        return brain.m_21874_(memory);
    }

    public static <T> void setMemory(LivingEntity entity, MemoryModuleType<T> memoryType, T memory) {
        BrainUtils.setMemory(entity.m_6274_(), memoryType, memory);
    }

    public static <T> void setMemory(Brain<?> brain, MemoryModuleType<T> memoryType, T memory) {
        brain.m_21879_(memoryType, memory);
    }

    public static void clearMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        BrainUtils.clearMemory(entity.m_6274_(), memory);
    }

    public static void clearMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        brain.m_21936_(memory);
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity) {
        return BrainUtils.getTargetOfEntity(entity, null);
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity, @Nullable LivingEntity fallback) {
        return BrainUtils.memoryOrDefault(entity.m_6274_(), MemoryModuleType.f_26372_, fallback);
    }

    @Nullable
    public static LivingEntity getLastAttacker(LivingEntity entity) {
        return BrainUtils.memoryOrDefault(entity, MemoryModuleType.f_26382_, null);
    }

    public static void setTargetOfEntity(LivingEntity entity, LivingEntity target) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6710_(target);
        }
        BrainUtils.setMemory(entity, MemoryModuleType.f_26372_, target);
    }
}

