/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.library.object.MutableSupplier;
import net.tslat.aoa3.util.ColourUtil;

public final class FluidUtil {

    public record RegisteredFluidHolder(RegistryObject<BucketItem> bucket, RegistryObject<LiquidBlock> fluidBlock, RegistryObject<ForgeFlowingFluid.Source> fluid) {
    }

    public static class Builder {
        private final String id;
        private final MutableSupplier<ForgeFlowingFluid.Source> sourceFluid = new MutableSupplier(null);
        private final MutableSupplier<ForgeFlowingFluid.Flowing> flowingFluid = new MutableSupplier(null);
        private BiFunction<MutableSupplier<ForgeFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction = (flowingFluid, blockProperties) -> () -> new LiquidBlock((Supplier)flowingFluid, blockProperties);
        private BiFunction<MutableSupplier<ForgeFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction = (sourceFluid, itemProperties) -> () -> new BucketItem((Supplier)sourceFluid, itemProperties);
        private Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Source>> sourceFluidFunction = properties -> () -> new ForgeFlowingFluid.Source(properties);
        private Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Flowing>> flowingFluidFunction = properties -> () -> new ForgeFlowingFluid.Flowing(properties);
        private Material material = Material.f_76305_;
        private boolean isGas = false;
        private int colour = -1;
        private int luminosity = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private Rarity rarity = Rarity.COMMON;
        private ResourceLocation stillTexture = new ResourceLocation("block/water_still");
        private ResourceLocation flowingTexture = new ResourceLocation("block/water_flow");
        private ResourceLocation overlayTexture = new ResourceLocation("block/water_overlay");
        private String localeKey;
        private SoundEvent fillSound = SoundEvents.f_11781_;
        private SoundEvent emptySound = SoundEvents.f_11778_;
        private ForgeFlowingFluid.Properties fluidProperties = null;

        public Builder(String id) {
            this.id = id;
            this.localeKey = "block.aoa3." + id;
        }

        public Builder material(Material material) {
            this.material = material;
            return this;
        }

        public Builder isGas() {
            this.isGas = true;
            return this;
        }

        public Builder colour(int colour) {
            this.colour = colour;
            return this;
        }

        public Builder colour(int red, int green, int blue, int alpha) {
            return this.colour(ColourUtil.RGBA(red, green, blue, alpha));
        }

        public Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public Builder density(int density) {
            this.density = density;
            return this;
        }

        public Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public Builder rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder stillTexture(ResourceLocation stillTexture) {
            this.stillTexture = stillTexture;
            return this;
        }

        public Builder flowingTexture(ResourceLocation flowingTexture) {
            this.flowingTexture = flowingTexture;
            return this;
        }

        public Builder submergedOverlay(ResourceLocation overlayTexture) {
            this.overlayTexture = overlayTexture;
            return this;
        }

        public Builder localeKey(String key) {
            this.localeKey = key;
            return this;
        }

        public Builder bucketFillSound(SoundEvent sound) {
            this.fillSound = sound;
            return this;
        }

        public Builder bucketEmptySound(SoundEvent sound) {
            this.emptySound = sound;
            return this;
        }

        public Builder isMolten() {
            this.material(Material.f_76307_);
            this.luminosity(15);
            this.density(3000);
            this.viscosity(6000);
            this.temperature(1300);
            this.bucketFillSound(SoundEvents.f_11783_);
            this.bucketEmptySound(SoundEvents.f_11780_);
            this.stillTexture(new ResourceLocation("block/lava_still"));
            this.flowingTexture(new ResourceLocation("block/lava_flow"));
            return this;
        }

        public Builder noBucket() {
            this.bucketCreationFunction = null;
            return this;
        }

        public Builder noBlock() {
            this.blockCreationFunction = null;
            return this;
        }

        public Builder customBlock(BiFunction<MutableSupplier<ForgeFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction) {
            this.blockCreationFunction = blockCreationFunction;
            return this;
        }

        public Builder customBucket(BiFunction<MutableSupplier<ForgeFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction) {
            this.bucketCreationFunction = bucketCreationFunction;
            return this;
        }

        public Builder customSourceFluid(Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Source>> sourceFluidCreationFunction) {
            this.sourceFluidFunction = sourceFluidCreationFunction;
            return this;
        }

        public Builder customFlowingFluid(Function<ForgeFlowingFluid.Properties, Supplier<ForgeFlowingFluid.Flowing>> flowingFluidCreationFunction) {
            this.flowingFluidFunction = flowingFluidCreationFunction;
            return this;
        }

        public RegistryObject<LiquidBlock> defaultRegisterAll() {
            return this.registerAll(AoARegistries.ITEMS.deferredRegister(), AoARegistries.BLOCKS.deferredRegister(), AoARegistries.FLUIDS.deferredRegister()).fluidBlock();
        }

        public RegisteredFluidHolder registerAll(DeferredRegister<Item> itemRegistry, DeferredRegister<Block> blockRegistry, DeferredRegister<Fluid> fluidRegistry) {
            RegistryObject<BucketItem> bucket = this.registerBucket(itemRegistry);
            RegistryObject<LiquidBlock> fluidBlock = this.registerBlock(blockRegistry);
            RegistryObject<ForgeFlowingFluid.Source> fluid = this.registerFluid(fluidRegistry);
            return new RegisteredFluidHolder(bucket, fluidBlock, fluid);
        }

        @Nullable
        public RegistryObject<LiquidBlock> registerBlock(DeferredRegister<Block> blockRegistry) {
            if (this.blockCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            RegistryObject block = blockRegistry.register(this.id, this.blockCreationFunction.apply(this.flowingFluid, BlockBehaviour.Properties.m_60939_((Material)this.material).m_60910_().m_60978_(100.0f).m_60993_().m_60953_(state -> this.luminosity)));
            this.fluidProperties.block((Supplier)block);
            if (this.material == Material.f_76305_) {
                AoABlocks.customRender(block, AoABlocks.CustomRenderType.TRANSLUCENT);
            }
            return block;
        }

        @Nullable
        public RegistryObject<BucketItem> registerBucket(DeferredRegister<Item> itemRegistry) {
            if (this.bucketCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            RegistryObject bucket = itemRegistry.register(this.id + "_bucket", this.bucketCreationFunction.apply(this.sourceFluid, new Item.Properties().m_41491_(AoAItemGroups.MISC_ITEMS).m_41487_(16).m_41495_(Items.f_42446_)));
            this.fluidProperties.bucket((Supplier)bucket);
            return bucket;
        }

        public RegistryObject<ForgeFlowingFluid.Source> registerFluid(DeferredRegister<Fluid> fluidRegistry) {
            this.makeFluidProperties();
            RegistryObject fluid = fluidRegistry.register(this.id, this.sourceFluidFunction.apply(this.fluidProperties));
            this.sourceFluid.update((Supplier<ForgeFlowingFluid.Source>)fluid);
            this.flowingFluid.update((Supplier<ForgeFlowingFluid.Flowing>)fluidRegistry.register(this.id + "_flowing", this.flowingFluidFunction.apply(this.fluidProperties)));
            return fluid;
        }

        private void makeFluidProperties() {
            if (this.fluidProperties == null) {
                FluidAttributes.Builder attributes = FluidAttributes.builder((ResourceLocation)this.stillTexture, (ResourceLocation)this.flowingTexture).overlay(this.overlayTexture).translationKey(this.localeKey).color(this.colour).rarity(this.rarity).temperature(this.temperature).viscosity(this.viscosity).density(this.density).luminosity(this.luminosity).sound(this.fillSound, this.emptySound);
                if (this.isGas) {
                    attributes.gaseous();
                }
                this.fluidProperties = new ForgeFlowingFluid.Properties(this.sourceFluid, this.flowingFluid, attributes);
            }
        }
    }
}

