/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTUtil {

    public static class NBTBuilder<T extends Tag> {
        private final T tag;
        private HashMap<String, NBTBuilder<?>> childTags;

        public NBTBuilder(T nbtBase) {
            this.tag = nbtBase;
        }

        public NBTBuilder<T> putTag(@Nullable String key, NBTBuilder<?> tag) {
            if (this.childTags == null) {
                this.childTags = new HashMap();
            }
            this.childTags.put(key, tag);
            return this;
        }

        public NBTBuilder<T> putString(@Nullable String key, String value) {
            if (this.tag.m_6458_() == CompoundTag.f_128326_ && key != null) {
                ((CompoundTag)this.tag).m_128365_(key, (Tag)StringTag.m_129297_((String)value));
            } else if (this.tag.m_6458_() == ListTag.f_128714_) {
                ((ListTag)this.tag).add((Object)StringTag.m_129297_((String)value));
            }
            return this;
        }

        public NBTBuilder<T> putInteger(@Nullable String key, int value) {
            if (this.tag.m_6458_() == CompoundTag.f_128326_ && key != null) {
                ((CompoundTag)this.tag).m_128365_(key, (Tag)IntTag.m_128679_((int)value));
            } else if (this.tag.m_6458_() == ListTag.f_128714_) {
                ((ListTag)this.tag).add((Object)IntTag.m_128679_((int)value));
            }
            return this;
        }

        public NBTBuilder<T> putFloat(@Nullable String key, float value) {
            if (this.tag.m_6458_() == CompoundTag.f_128326_ && key != null) {
                ((CompoundTag)this.tag).m_128365_(key, (Tag)FloatTag.m_128566_((float)value));
            } else if (this.tag.m_6458_() == ListTag.f_128714_) {
                ((ListTag)this.tag).add((Object)FloatTag.m_128566_((float)value));
            }
            return this;
        }

        public NBTBuilder<T> putLong(@Nullable String key, long value) {
            if (this.tag.m_6458_() == CompoundTag.f_128326_ && key != null) {
                ((CompoundTag)this.tag).m_128365_(key, (Tag)LongTag.m_128882_((long)value));
            } else if (this.tag.m_6458_() == ListTag.f_128714_) {
                ((ListTag)this.tag).add((Object)LongTag.m_128882_((long)value));
            }
            return this;
        }

        public T build() {
            if (this.childTags != null && !this.childTags.isEmpty()) {
                if (this.tag.m_6458_() == CompoundTag.f_128326_) {
                    Map.Entry firstEntry = (Map.Entry)this.childTags.entrySet().stream().findFirst().get();
                    ((CompoundTag)this.tag).m_128365_((String)firstEntry.getKey(), ((NBTBuilder)firstEntry.getValue()).build());
                } else if (this.tag.m_6458_() == ListTag.f_128714_) {
                    for (Map.Entry<String, NBTBuilder<?>> childEntry : this.childTags.entrySet()) {
                        ((ListTag)this.tag).add(childEntry.getValue().build());
                    }
                }
            }
            return this.tag;
        }
    }
}

