/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public final class TagUtil {
    public static ITagManager<Block> blockTags() {
        return ForgeRegistries.BLOCKS.tags();
    }

    public static ITagManager<Item> itemTags() {
        return ForgeRegistries.ITEMS.tags();
    }

    public static ITagManager<Fluid> fluidTags() {
        return ForgeRegistries.FLUIDS.tags();
    }

    public static ITagManager<EntityType<?>> entityTags() {
        return ForgeRegistries.ENTITIES.tags();
    }

    public static boolean isTaggedAs(Block block, TagKey<Block> tagKey) {
        return TagUtil.blockTags().getTag(tagKey).contains((Object)block);
    }

    public static boolean isTaggedAs(BlockState blockState, TagKey<Block> tagKey) {
        return TagUtil.isTaggedAs(blockState.m_60734_(), tagKey);
    }

    public static boolean isTaggedAs(Item item, TagKey<Item> tagKey) {
        return TagUtil.itemTags().getTag(tagKey).contains((Object)item);
    }

    public static boolean isTaggedAs(ItemStack itemStack, TagKey<Item> tagKey) {
        return TagUtil.isTaggedAs(itemStack.m_41720_(), tagKey);
    }

    public static boolean isTaggedAs(Fluid fluid, TagKey<Fluid> tagKey) {
        return TagUtil.fluidTags().getTag(tagKey).contains((Object)fluid);
    }

    public static boolean isTaggedAs(FluidState fluidState, TagKey<Fluid> tagKey) {
        return TagUtil.isTaggedAs(fluidState.m_76152_(), tagKey);
    }

    public static boolean isTaggedAs(EntityType<?> entityType, TagKey<EntityType<?>> tagKey) {
        return TagUtil.entityTags().getTag(tagKey).contains(entityType);
    }

    public static boolean isTaggedAs(Entity entity, TagKey<EntityType<?>> tagKey) {
        return TagUtil.isTaggedAs(entity.m_6095_(), tagKey);
    }
}

