/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.scheduling.async.UpdateHalosMapTask;
import net.tslat.aoa3.util.AoAHaloUtil;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public final class WebUtil {
    private static boolean isUpdateAvailable = false;
    private static String latestVersion = "1.18.2-3.6.6";

    public static void doHTTPTasks() {
        Logging.logMessage(Level.DEBUG, "Starting web tasks");
        VersionChecker.CheckResult updateCheckResult = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("aoa3").getMods().get(0)));
        if (updateCheckResult.status() == VersionChecker.Status.OUTDATED) {
            isUpdateAvailable = true;
            latestVersion = updateCheckResult.target().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<UUID, AoAHaloUtil.PlayerHaloContainer> fillHalosMap(HashMap<UUID, AoAHaloUtil.PlayerHaloContainer> halosMap) {
        Logging.logMessage(Level.DEBUG, "Updating player halos map");
        BufferedReader fileReader = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://gist.githubusercontent.com/Tslat/2c2eb98dceeff18f05ed068982fb71a7/raw/").openConnection();
            connection.setConnectTimeout(1000);
            connection.connect();
            if (200 != connection.getResponseCode()) {
                Logging.logMessage(Level.DEBUG, "Failed connection to cloud based halos map, response code " + connection.getResponseMessage());
                HashMap<UUID, AoAHaloUtil.PlayerHaloContainer> hashMap = halosMap;
                return hashMap;
            }
            fileReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            if (halosMap != null) {
                String line;
                while ((line = fileReader.readLine()) != null) {
                    UUID uuid;
                    String[] lineSplit;
                    if (line.startsWith(" <!DOCTYPE") || (lineSplit = line.split("\\|")).length <= 2) continue;
                    HashSet<AoAHaloUtil.Type> halosSet = new HashSet<AoAHaloUtil.Type>(lineSplit.length - 1);
                    try {
                        uuid = UUID.fromString(lineSplit[1]);
                    }
                    catch (IllegalArgumentException ex) {
                        Logging.logMessage(Level.WARN, "Invalid UUID format from web: " + lineSplit[1]);
                        continue;
                    }
                    for (int i = 2; i < lineSplit.length; ++i) {
                        try {
                            halosSet.add(AoAHaloUtil.Type.valueOf(lineSplit[i]));
                            continue;
                        }
                        catch (IllegalArgumentException ex) {
                            Logging.logMessage(Level.WARN, "Invalid halo type from web: " + lineSplit[i]);
                        }
                    }
                    halosMap.put(uuid, new AoAHaloUtil.PlayerHaloContainer(halosSet));
                    Logging.logMessage(Level.DEBUG, "Found player halo for " + uuid.toString());
                }
                HashSet<AoAHaloUtil.Type> haloSet = new HashSet<AoAHaloUtil.Type>(1);
                haloSet.add(AoAHaloUtil.Type.Tslat);
                halosMap.put(UUID.fromString("2459b511-ca45-43d8-808d-f0eb30a63be4"), new AoAHaloUtil.PlayerHaloContainer(haloSet));
            }
            connection.disconnect();
            IOUtils.closeQuietly((Reader)fileReader);
        }
        catch (Exception e) {
            Logging.logMessage(Level.WARN, "Error while performing HTTP Tasks, dropping.", e);
        }
        finally {
            IOUtils.closeQuietly(fileReader);
        }
        return halosMap;
    }

    public static void extraPlayerHalosFromWeb() {
        HashMap<UUID, AoAHaloUtil.PlayerHaloContainer> newMap = AoAHaloUtil.getHaloMapForPrefill();
        if (newMap != null) {
            WebUtil.fillHalosMap(newMap);
            AoAScheduler.scheduleAsyncTask(new UpdateHalosMapTask(), 60, TimeUnit.MINUTES);
        }
    }

    public static boolean isUpdateAvailable() {
        return isUpdateAvailable;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

