/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.provider.GeoModelProvider;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;

public abstract class GeoLayerRenderer<T extends Entity> {
    private final IGeoRenderer<T> entityRenderer;

    public GeoLayerRenderer(IGeoRenderer<T> entityRendererIn) {
        this.entityRenderer = entityRendererIn;
    }

    protected void renderCopyModel(GeoModelProvider<T> modelProviderIn, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityIn, float partialTicks, float red, float green, float blue) {
        if (!entityIn.m_20145_()) {
            this.renderModel(modelProviderIn, textureLocationIn, matrixStackIn, bufferIn, packedLightIn, entityIn, partialTicks, red, green, blue);
        }
    }

    protected void renderModel(GeoModelProvider<T> modelProviderIn, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityIn, float partialTicks, float red, float green, float blue) {
        if (entityIn instanceof LivingEntity) {
            GeoModel model = modelProviderIn.getModel(modelProviderIn.getModelLocation(entityIn));
            RenderType renderType = this.getRenderType(textureLocationIn);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(renderType);
            this.getRenderer().render(model, entityIn, partialTicks, renderType, matrixStackIn, bufferIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)((LivingEntity)entityIn), (float)0.0f), red, green, blue, 1.0f);
        }
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.m_110452_((ResourceLocation)textureLocation);
    }

    public GeoModelProvider<T> getEntityModel() {
        return this.entityRenderer.getGeoModelProvider();
    }

    public IGeoRenderer<T> getRenderer() {
        return this.entityRenderer;
    }

    protected ResourceLocation getEntityTexture(T entityIn) {
        return this.entityRenderer.getTextureLocation(entityIn);
    }

    public abstract void render(PoseStack var1, MultiBufferSource var2, int var3, T var4, float var5, float var6, float var7, float var8, float var9, float var10);
}

