/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Collections;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.aoa3.geckolib3.core.IAnimatableModel;
import software.bernie.aoa3.geckolib3.core.controller.AnimationController;
import software.bernie.aoa3.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.aoa3.geckolib3.core.util.Color;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.AnimatedGeoModel;
import software.bernie.aoa3.geckolib3.model.provider.GeoModelProvider;
import software.bernie.aoa3.geckolib3.model.provider.data.EntityModelData;
import software.bernie.aoa3.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.aoa3.geckolib3.util.AnimationUtils;

public class GeoProjectilesRenderer<T extends Entity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    private final AnimatedGeoModel<T> modelProvider;

    public GeoProjectilesRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entityIn));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((Entity)entityIn).f_19859_, (float)entityIn.m_146908_()) - 90.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((Entity)entityIn).f_19860_, (float)entityIn.m_146909_())));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.m_5478_(entityIn));
        Color renderColor = this.getRenderColor(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.m_5478_(entityIn));
        this.render(model, entityIn, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, GeoProjectilesRenderer.getPackedOverlay(entityIn, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        EntityModelData entityModelData = new EntityModelData();
        AnimationEvent<T> predicate = new AnimationEvent<T>(entityIn, limbSwing, lastLimbDistance, partialTicks, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entityIn, this.getUniqueID(entityIn), (AnimationEvent)predicate);
        }
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public static int getPackedOverlay(Entity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((boolean)false));
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ResourceLocation m_5478_(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof Entity) {
                return (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)object));
            }
            return null;
        });
    }
}

