/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import software.bernie.aoa3.geckolib3.GeckoLib;
import software.bernie.aoa3.geckolib3.file.AnimationFile;
import software.bernie.aoa3.geckolib3.file.AnimationFileLoader;
import software.bernie.aoa3.geckolib3.file.GeoModelLoader;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.molang.MolangRegistrar;
import software.bernie.aoa3.shadowed.eliotlash.molang.MolangParser;

public class GeckoLibCache {
    private static GeckoLibCache INSTANCE;
    private final AnimationFileLoader animationLoader;
    private final GeoModelLoader modelLoader;
    public final MolangParser parser = new MolangParser();
    private Map<ResourceLocation, AnimationFile> animations = Collections.emptyMap();
    private Map<ResourceLocation, GeoModel> geoModels = Collections.emptyMap();

    public Map<ResourceLocation, AnimationFile> getAnimations() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return this.animations;
    }

    public Map<ResourceLocation, GeoModel> getGeoModels() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return this.geoModels;
    }

    protected GeckoLibCache() {
        this.animationLoader = new AnimationFileLoader();
        this.modelLoader = new GeoModelLoader();
        MolangRegistrar.registerVars(this.parser);
    }

    public static GeckoLibCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GeckoLibCache();
            return INSTANCE;
        }
        return INSTANCE;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashMap animations = new HashMap();
        HashMap geoModels = new HashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "animations", animation -> this.animationLoader.loadAllAnimations(this.parser, (ResourceLocation)animation, resourceManager), animations::put);
        completableFutureArray[1] = GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> this.modelLoader.loadModel(resourceManager, (ResourceLocation)resource), geoModels::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(empty -> {
            this.animations = animations;
            this.geoModels = geoModels;
        }, gameExecutor);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, ResourceManager resourceManager, String type, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.m_6540_(type, fileName -> fileName.endsWith(".json")), executor).thenApplyAsync(resources -> {
            HashMap<ResourceLocation, CompletableFuture<Object>> tasks = new HashMap<ResourceLocation, CompletableFuture<Object>>();
            for (ResourceLocation resource : resources) {
                CompletableFuture<Object> existing = tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
                if (existing == null) continue;
                System.err.println("Duplicate resource for " + resource);
                existing.cancel(false);
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }
}

