/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.api.fish;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;

public class FishData {
    private final ConcurrentHashMap<Item, Double> WEIGHT_MIN = new ConcurrentHashMap();
    private final ConcurrentHashMap<Item, Double> WEIGHT_MAX = new ConcurrentHashMap();
    private final ConcurrentHashMap<Item, Integer> FILLET_AMOUNT = new ConcurrentHashMap();

    public void addWeight(Item fish, double min, double max) {
        this.WEIGHT_MIN.put(fish, min);
        this.WEIGHT_MAX.put(fish, max);
    }

    public double getMinWeight(Item fish) {
        return this.WEIGHT_MIN.get(fish);
    }

    public double getMinWeight(Item fish, double defaultValue) {
        return this.WEIGHT_MIN.getOrDefault(fish, defaultValue);
    }

    public double getMaxWeight(Item fish) {
        return this.WEIGHT_MAX.get(fish);
    }

    public double getMaxWeight(Item fish, double defaultValue) {
        return this.WEIGHT_MAX.getOrDefault(fish, defaultValue);
    }

    public boolean hasWeight(Item fish) {
        return this.WEIGHT_MIN.containsKey(fish) || this.WEIGHT_MAX.containsKey(fish);
    }

    public List<Item> getFish() {
        return new ArrayList<Item>(this.WEIGHT_MIN.keySet());
    }

    public void add(Item fish, double min, double max) {
        this.add(fish, min, max, 1);
    }

    public void add(Item fish, double min, double max, int filletAmount) {
        this.addWeight(fish, min, max);
        if (filletAmount > 0) {
            this.addFilletAmount(fish, filletAmount);
        }
    }

    public void addFilletAmount(Item fish, int filletAmount) {
        this.FILLET_AMOUNT.put(fish, filletAmount);
    }

    public void remove(Item fish) {
        this.WEIGHT_MIN.remove(fish);
        this.WEIGHT_MAX.remove(fish);
        if (this.hasFilletAmount(fish)) {
            this.FILLET_AMOUNT.remove(fish);
        }
    }

    public boolean hasFilletAmount(Item fish) {
        return this.FILLET_AMOUNT.containsKey(fish);
    }

    public int getFilletAmount(Item fish) {
        return this.FILLET_AMOUNT.get(fish);
    }

    public int getFilletAmount(Item fish, int defaultValue) {
        return this.FILLET_AMOUNT.getOrDefault(fish, defaultValue);
    }

    public static int getFilletAmountFromWeight(double weight) {
        if (weight >= 2.0 && weight < 10.0) {
            return 1;
        }
        if (weight >= 10.0 && weight < 50.0) {
            return 2;
        }
        if (weight >= 50.0 && weight < 100.0) {
            return 3;
        }
        if (weight >= 100.0 && weight < 150.0) {
            return 4;
        }
        if (weight >= 150.0 && weight < 200.0) {
            return 5;
        }
        if (weight >= 200.0 && weight < 250.0) {
            return 6;
        }
        if (weight >= 250.0 && weight < 300.0) {
            return 7;
        }
        if (weight >= 300.0 && weight < 350.0) {
            return 8;
        }
        if (weight >= 350.0 && weight < 400.0) {
            return 9;
        }
        if (weight >= 400.0 && weight < 450.0) {
            return 10;
        }
        if (weight >= 450.0 && weight < 500.0) {
            return 11;
        }
        if (weight >= 500.0 && weight < 600.0) {
            return 12;
        }
        if (weight >= 600.0 && weight < 700.0) {
            return 13;
        }
        if (weight >= 700.0 && weight < 800.0) {
            return 14;
        }
        if (weight >= 800.0 && weight < 1000.0) {
            return 15;
        }
        if (weight >= 1000.0) {
            return 16;
        }
        return 0;
    }
}

