/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.common.meteor.MeteorLayer;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeMeteor
extends BloodMagicRecipe {
    @Nonnull
    protected final Ingredient input;
    @Nonnegative
    private final int syphon;
    private final float explosionRadius;
    private final List<MeteorLayer> layerList;

    public RecipeMeteor(ResourceLocation id, Ingredient input, int syphon, float explosionRadius, List<MeteorLayer> layerList) {
        super(id);
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((explosionRadius >= 0.0f ? 1 : 0) != 0, (Object)"explosionRadius cannot be negative.");
        this.input = input;
        this.syphon = syphon;
        this.explosionRadius = explosionRadius;
        this.layerList = layerList;
    }

    public void spawnMeteorInWorld(Level world, BlockPos centerPos) {
        if (this.explosionRadius > 0.0f) {
            world.m_46518_(null, (double)centerPos.m_123341_(), (double)centerPos.m_123342_(), (double)centerPos.m_123343_(), this.explosionRadius, true, Explosion.BlockInteraction.DESTROY);
        }
        HashMap<Integer, MeteorLayer> layerMap = new HashMap<Integer, MeteorLayer>();
        for (MeteorLayer layer : this.layerList) {
            layerMap.put(layer.layerRadius, layer);
        }
        ArrayList keyList = new ArrayList(layerMap.keySet());
        Collections.sort(keyList);
        int prevRadius = -1;
        for (int i = 0; i < keyList.size(); ++i) {
            MeteorLayer layer = (MeteorLayer)layerMap.get(keyList.get(i));
            layer.buildLayer(world, centerPos, prevRadius);
            prevRadius = layer.layerRadius;
        }
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public final int getSyphon() {
        return this.syphon;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.writeInt(this.getSyphon());
        buffer.writeFloat(this.explosionRadius);
        buffer.writeInt(this.layerList.size());
        for (int i = 0; i < this.layerList.size(); ++i) {
            this.layerList.get(i).write(buffer);
        }
    }

    public RecipeSerializer<? extends RecipeMeteor> m_7707_() {
        return BloodMagicRecipeSerializers.METEOR.getRecipeSerializer();
    }

    public RecipeType<RecipeMeteor> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.METEOR.get();
    }
}

