/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="ellipsoid")
public class RitualEllipsoid
extends Ritual {
    public static final String SPHEROID_RANGE = "spheroidRange";
    public static final String CHEST_RANGE = "chest";
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualEllipsoid() {
        super("ritualEllipsoid", 0, 20000, "ritual.bloodmagic.ellipseRitual");
        this.addBlockRange(SPHEROID_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), new BlockPos(11, 11, 11)));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(SPHEROID_RANGE, 0, 32, 32);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity tileInventory = world.m_7702_(chestRange.getContainedPositions(masterPos).get(0));
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor sphereRange = masterRitualStone.getBlockRange(SPHEROID_RANGE);
        AABB sphereBB = sphereRange.getAABB(masterPos);
        int minX = (int)((double)masterPos.m_123341_() - sphereBB.f_82288_);
        int maxX = (int)(sphereBB.f_82291_ - (double)masterPos.m_123341_()) - 1;
        int minY = (int)((double)masterPos.m_123342_() - sphereBB.f_82289_);
        int maxY = (int)(sphereBB.f_82292_ - (double)masterPos.m_123342_()) - 1;
        int minZ = (int)((double)masterPos.m_123343_() - sphereBB.f_82290_);
        int maxZ = (int)(sphereBB.f_82293_ - (double)masterPos.m_123343_()) - 1;
        if (tileInventory != null && tileInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)tileInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).resolve().get();
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            int blockSlot = -1;
            for (int invSlot = 0; invSlot < itemHandler.getSlots(); ++invSlot) {
                ItemStack stack = itemHandler.extractItem(invSlot, 1, true);
                if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) continue;
                blockSlot = invSlot;
                break;
            }
            if (blockSlot == -1) {
                return;
            }
            int xR = Math.max(maxX, minX);
            int yR = Math.max(maxY, minY);
            int zR = Math.max(maxZ, minZ);
            int j = -minX;
            int i = -minY;
            int k = -minZ;
            if (this.currentPos != null) {
                j = this.currentPos.m_123342_();
                i = Math.min(xR, Math.max(-minX, this.currentPos.m_123341_()));
                k = Math.min(zR, Math.max(-minZ, this.currentPos.m_123343_()));
            }
            int checks = 0;
            int maxChecks = 100;
            if (j <= maxY) {
                while (i <= maxX) {
                    while (k <= maxZ) {
                        if (++checks >= maxChecks) {
                            this.currentPos = new BlockPos(i, j, k);
                            return;
                        }
                        if (this.checkIfEllipsoidShell(xR, yR, zR, i, j, k)) {
                            BlockPos newPos = masterPos.m_142082_(i, j, k);
                            if (!world.m_46859_(newPos)) {
                                ++k;
                                continue;
                            }
                            BlockState placeState = Block.m_49814_((Item)itemHandler.getStackInSlot(blockSlot).m_41720_()).m_49966_();
                            world.m_46597_(newPos, placeState);
                            itemHandler.extractItem(blockSlot, 1, false);
                            tileInventory.m_6596_();
                            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                            this.currentPos = new BlockPos(i, j, ++k);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                    k = -minZ;
                }
                i = -minX;
                this.currentPos = new BlockPos(i, ++j, k);
                return;
            }
            j = -minY;
            this.currentPos = new BlockPos(i, j, k);
            return;
        }
    }

    public boolean checkIfEllipsoidShell(int xR, int yR, int zR, int xOff, int yOff, int zOff) {
        if (!this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff)) {
            return false;
        }
        return !this.checkIfEllipsoid(xR, yR, zR, xOff + 1, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff - 1, yOff, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff + 1, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff - 1, zOff) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff + 1) || !this.checkIfEllipsoid(xR, yR, zR, xOff, yOff, zOff - 1);
    }

    public boolean checkIfEllipsoid(float xR, float yR, float zR, float xOff, float yOff, float zOff) {
        float possOffset = 0.5f;
        return xOff * xOff / ((xR + possOffset) * (xR + possOffset)) + yOff * yOff / ((yR + possOffset) * (yR + possOffset)) + zOff * zOff / ((zR + possOffset) * (zR + possOffset)) <= 1.0f;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addRune(components, 4, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, 5, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, 5, 0, -1, EnumRuneType.FIRE);
        this.addRune(components, 5, 0, -2, EnumRuneType.FIRE);
        this.addRune(components, -4, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, -5, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, -5, 0, 1, EnumRuneType.FIRE);
        this.addRune(components, -5, 0, 2, EnumRuneType.FIRE);
        this.addRune(components, 0, 0, 4, EnumRuneType.AIR);
        this.addRune(components, 0, 0, 5, EnumRuneType.AIR);
        this.addRune(components, 1, 0, 5, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 5, EnumRuneType.AIR);
        this.addRune(components, 0, 0, -4, EnumRuneType.AIR);
        this.addRune(components, 0, 0, -5, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -5, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -5, EnumRuneType.AIR);
        this.addRune(components, 3, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 2, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, 2, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -2, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, -2, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, -3, EnumRuneType.WATER);
        this.addRune(components, 2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -3, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -2, EnumRuneType.WATER);
        this.addRune(components, -1, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 2, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualEllipsoid();
    }
}

