/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerHelper {
    private static final ArrayList<String> knownFakePlayers = Lists.newArrayList();

    public static Player getPlayerFromId(UUID uuid) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
    }

    public static Player getPlayerFromUUID(UUID uuid) {
        return PlayerHelper.getPlayerFromId(uuid);
    }

    public static UUID getUUIDFromPlayer(Player player) {
        return player.m_36316_().getId();
    }

    public static String getUsernameFromUUID(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer || player != null && knownFakePlayers.contains(player.getClass().getCanonicalName());
    }
}

